/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.provider;

import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.provider.IEObjectAccessor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.swt.graphics.Image;

public class EObjectNode
implements ITypedElement,
IEObjectAccessor,
IStreamContentAccessor {
    private final EObject fEObject;
    private final AdapterFactory fAdapterFactory;

    public EObjectNode(AdapterFactory adapterFactory, EObject eObject) {
        this.fAdapterFactory = adapterFactory;
        this.fEObject = eObject;
    }

    public String getName() {
        return this.fEObject.eClass().getName();
    }

    public Image getImage() {
        Adapter adapter = this.fAdapterFactory.adapt((Notifier)this.fEObject, IItemLabelProvider.class);
        if (adapter instanceof IItemLabelProvider) {
            Object image = ((IItemLabelProvider)adapter).getImage((Object)this.fEObject);
            return ExtendedImageRegistry.getInstance().getImage(image);
        }
        return null;
    }

    public String getType() {
        return "eobject";
    }

    public EObject getEObject() {
        return this.fEObject;
    }

    public InputStream getContents() throws CoreException {
        XMIResourceImpl r = new XMIResourceImpl(URI.createURI((String)"dummy.xmi"));
        EObject copy = EcoreUtil.copy((EObject)this.fEObject);
        r.getContents().add((Object)copy);
        StringWriter sw = new StringWriter();
        try {
            r.save((Writer)sw, (Map)Maps.newHashMap());
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.emf.compare.ide.ui", e.getMessage(), (Throwable)e));
        }
        return new ByteArrayInputStream(sw.toString().getBytes());
    }
}

