/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.provider;

import com.google.common.collect.Iterables;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.IMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.provider.AbstractDiffAccessor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.swt.graphics.Image;

public class ReferenceChangeAccessor
extends AbstractDiffAccessor {
    public ReferenceChangeAccessor(ReferenceChange referenceChange, IMergeViewer.MergeViewerSide side) {
        super((Diff)referenceChange, side);
    }

    public EObject getValue(Diff diff) {
        EObject value;
        block6: {
            block5: {
                Match matchOfValue = this.getMatch(diff);
                if (matchOfValue == null) break block5;
                switch (this.getSide()) {
                    case ANCESTOR: {
                        value = matchOfValue.getOrigin();
                        break block6;
                    }
                    case LEFT: {
                        value = matchOfValue.getLeft();
                        break block6;
                    }
                    case RIGHT: {
                        value = matchOfValue.getRight();
                        break block6;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            value = null;
        }
        return value;
    }

    public Match getMatch() {
        return this.getMatch(this.getDiff());
    }

    private Match getMatch(Diff diff) {
        Match match = diff.getMatch();
        Match matchOfValue = match.getComparison().getMatch(((ReferenceChange)diff).getValue());
        return matchOfValue;
    }

    public Diff getDiff(Object value, IMergeViewer.MergeViewerSide side) {
        ReferenceChange ret = null;
        Iterable referencesChanges = Iterables.filter(this.getDiffFromThisSide(), ReferenceChange.class);
        for (ReferenceChange referenceChange : referencesChanges) {
            EObject matchValue;
            EObject referenceChangeValue = referenceChange.getValue();
            Match match = referenceChange.getMatch().getComparison().getMatch(referenceChangeValue);
            if (match == null) continue;
            switch (side) {
                case LEFT: {
                    matchValue = match.getLeft();
                    break;
                }
                case RIGHT: {
                    matchValue = match.getRight();
                    break;
                }
                default: {
                    matchValue = null;
                }
            }
            if (matchValue != value) continue;
            ret = referenceChange;
            break;
        }
        return ret;
    }

    public String getName() {
        return ReferenceChangeAccessor.class.getName();
    }

    public Image getImage() {
        return ExtendedImageRegistry.getInstance().getImage(EcoreEditPlugin.getPlugin().getImage("full/obj16/EReference"));
    }

    public String getType() {
        return "objectlist";
    }
}

