/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.table;

import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.EMFCompareContentMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.IMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.provider.IStructuralFeatureAccessor;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.table.TableContentMergeViewerContentProvider;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.table.TableMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.DiffInsertionPoint;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scrollable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableContentMergeViewer
extends EMFCompareContentMergeViewer {
    private static final String BUNDLE_NAME = TableContentMergeViewer.class.getName();
    private final AdapterFactory fAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);

    protected TableContentMergeViewer(Composite parent, CompareConfiguration config) {
        super(0, ResourceBundle.getBundle(BUNDLE_NAME), config);
        this.buildControl(parent);
        this.setContentProvider((IContentProvider)new TableContentMergeViewerContentProvider(config));
    }

    protected void copy(boolean leftToRight) {
        EList differences = this.getComparison().getDifferences();
        boolean merged = false;
        for (Diff diff : differences) {
            if (leftToRight && diff.getSource() == DifferenceSource.LEFT && diff.getState() == DifferenceState.UNRESOLVED) {
                if (diff.getConflict() != null && diff.getConflict().getKind() != ConflictKind.PSEUDO) continue;
                diff.copyLeftToRight();
                merged = true;
                continue;
            }
            if (leftToRight || diff.getSource() != DifferenceSource.RIGHT || diff.getState() != DifferenceState.UNRESOLVED || diff.getConflict() != null && diff.getConflict().getKind() != ConflictKind.PSEUDO) continue;
            diff.copyRightToLeft();
            merged = true;
        }
        if (merged) {
            if (leftToRight) {
                this.setRightDirty(true);
            } else {
                this.setLeftDirty(true);
            }
            this.refresh();
        }
    }

    protected byte[] getContents(boolean left) {
        return null;
    }

    @Override
    protected void copyDiffRightToLeft() {
        Diff diffToCopy = this.getDiffToCopy(this.getRightMergeViewer(), IMergeViewer.MergeViewerSide.RIGHT);
        if (diffToCopy != null) {
            diffToCopy.copyRightToLeft();
            this.setLeftDirty(true);
            this.refresh();
        }
    }

    private Diff getDiffToCopy(IMergeViewer<? extends Scrollable> mergeViewer, IMergeViewer.MergeViewerSide side) {
        Diff diffToCopy = null;
        ISelection selection = mergeViewer.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Object firstElement = ((IStructuredSelection)selection).getFirstElement();
            if (firstElement instanceof DiffInsertionPoint) {
                diffToCopy = ((DiffInsertionPoint)firstElement).getDiff();
            } else {
                Object mergeViewerInput = mergeViewer.getInput();
                if (mergeViewerInput instanceof IStructuralFeatureAccessor) {
                    diffToCopy = ((IStructuralFeatureAccessor)mergeViewerInput).getDiff(firstElement, side);
                }
            }
        }
        return diffToCopy;
    }

    @Override
    protected void copyDiffLeftToRight() {
        Diff diffToCopy = this.getDiffToCopy(this.getLeftMergeViewer(), IMergeViewer.MergeViewerSide.LEFT);
        if (diffToCopy != null) {
            diffToCopy.copyLeftToRight();
            this.setRightDirty(true);
            this.refresh();
        }
    }

    protected IMergeViewer<? extends Composite> createMergeViewer(Composite parent, IMergeViewer.MergeViewerSide side) {
        TableMergeViewer ret = new TableMergeViewer(parent, this, side);
        ret.setContentProvider((IContentProvider)new ArrayContentProvider());
        ret.setLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider(this.fAdapterFactory));
        return ret;
    }

    @Override
    protected void paintCenter(Canvas canvas, GC g) {
    }
}

