/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.table;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.AbstractMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.EMFCompareContentMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.IMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.provider.IStructuralFeatureAccessor;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.DiffInsertionPoint;
import org.eclipse.emf.compare.utils.DiffUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TableMergeViewer
extends AbstractMergeViewer<Table> {
    private IStructuralFeatureAccessor fInput;
    private final EMFCompareContentMergeViewer fContentMergeViewer;
    private ImmutableMap<Match, DiffInsertionPoint> fInsertionPoints;

    TableMergeViewer(Composite parent, EMFCompareContentMergeViewer contentMergeViewer, IMergeViewer.MergeViewerSide side) {
        super(parent, side);
        this.fContentMergeViewer = contentMergeViewer;
        this.fInsertionPoints = ImmutableMap.of();
        this.getControl().addListener(40, new Listener(){

            public void handleEvent(Event event) {
                TableMergeViewer.this.handleEraseItemEvent(event);
            }
        });
        this.getControl().addListener(41, new Listener(){
            private Widget fLastWidget;
            private int fLastHeight;

            public void handleEvent(Event event) {
                if (event.item == this.fLastWidget && event.height == this.fLastHeight) {
                    return;
                }
                this.fLastWidget = event.item;
                this.fLastHeight = event.height;
                int newHeight = (int)((double)event.gc.getFontMetrics().getHeight() * 1.33);
                if (newHeight % 2 == 1) {
                    ++newHeight;
                }
                event.height = newHeight;
            }
        });
    }

    @Override
    public Table getControl() {
        return this.getStructuredViewer().getTable();
    }

    protected final TableViewer createStructuredViewer(Composite parent) {
        return new TableViewer(parent);
    }

    protected TableViewer getStructuredViewer() {
        return (TableViewer)super.getStructuredViewer();
    }

    @Override
    public void setInput(Object object) {
        if (object instanceof IStructuralFeatureAccessor) {
            this.fInput = (IStructuralFeatureAccessor)object;
            ArrayList values = Lists.newArrayList(this.fInput.getValues());
            this.addInsertionPoints(values);
            this.getStructuredViewer().setInput((Object)values);
        } else {
            this.fInput = null;
            this.getStructuredViewer().setInput(null);
        }
    }

    public Object getInput() {
        return this.fInput;
    }

    @Override
    public void setSelection(Object selection) {
        if (selection instanceof IStructuralFeatureAccessor) {
            this.setSelection((IStructuralFeatureAccessor)selection);
        } else {
            this.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private void setSelection(IStructuralFeatureAccessor selection) {
        if (selection != null) {
            Object value = selection.getValue();
            if (((Collection)this.getStructuredViewer().getInput()).contains(value)) {
                this.setSelection((ISelection)new StructuredSelection(value));
            } else {
                DiffInsertionPoint insertionPoint = (DiffInsertionPoint)this.fInsertionPoints.get((Object)selection.getMatch());
                if (insertionPoint != null) {
                    this.setSelection((ISelection)new StructuredSelection((Object)insertionPoint));
                } else {
                    this.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            }
        } else {
            this.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private void addInsertionPoints(List<Object> values) {
        ImmutableMap.Builder insertionsPoints = ImmutableMap.builder();
        for (ReferenceChange diff : Iterables.filter((Iterable)this.fInput.getDiffFromTheOtherSide().reverse(), ReferenceChange.class)) {
            Match match;
            Match matchOfDiffValue;
            if (diff.getState() != DifferenceState.UNRESOLVED) continue;
            boolean rightToLeft = this.getSide() == IMergeViewer.MergeViewerSide.LEFT;
            EObject value = diff.getValue();
            if (value == null || (matchOfDiffValue = (match = diff.getMatch()).getComparison().getMatch(value)) == null) continue;
            DiffInsertionPoint insertionPoint = new DiffInsertionPoint((Diff)diff);
            int insertionIndex = diff.getReference().isMany() ? DiffUtil.findInsertionIndex((Comparison)match.getComparison(), (Diff)diff, (boolean)rightToLeft) : 0;
            values.add(insertionIndex, insertionPoint);
            insertionsPoints.put((Object)matchOfDiffValue, (Object)insertionPoint);
        }
        this.fInsertionPoints = insertionsPoints.build();
    }

    @Override
    public void setSelection(Match match) {
        EObject eObject;
        switch (this.getSide()) {
            case ANCESTOR: {
                eObject = match.getOrigin();
                break;
            }
            case LEFT: {
                eObject = match.getLeft();
                break;
            }
            case RIGHT: {
                eObject = match.getRight();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        DiffInsertionPoint insertionPoint = (DiffInsertionPoint)this.fInsertionPoints.get((Object)match);
        ISelection selection = this.createSelectionForFirstNonNull(eObject, insertionPoint);
        this.setSelection(selection);
    }

    private ISelection createSelectionForFirstNonNull(Object first, Object second) {
        StructuredSelection selection = first != null ? new StructuredSelection(first) : (second != null ? new StructuredSelection(second) : StructuredSelection.EMPTY);
        return selection;
    }

    private void handleEraseItemEvent(Event event) {
        TableItem tableItem = (TableItem)event.item;
        Object data = tableItem.getData();
        boolean specialPaint = false;
        if (data instanceof DiffInsertionPoint) {
            DiffInsertionPoint insertionPoint = (DiffInsertionPoint)data;
            this.paintItemDiffBox(event, insertionPoint.getDiff(), TableMergeViewer.getBoundsForInsertionPoint(tableItem));
            specialPaint = true;
        } else if (this.fInput != null) {
            for (Diff diff : this.fInput.getDiffFromThisSide()) {
                if (this.fInput.getValue(diff) != data) continue;
                this.paintItemDiffBox(event, diff, TableMergeViewer.getBounds(tableItem));
                specialPaint = true;
            }
            if (this.getSide() == IMergeViewer.MergeViewerSide.ANCESTOR) {
                for (Diff diff : this.fInput.getDiffFromAncestor()) {
                    if (this.fInput.getValue(diff) != data) continue;
                    this.paintItemDiffBox(event, diff, TableMergeViewer.getBounds(tableItem));
                    specialPaint = true;
                }
            }
        }
        if (!specialPaint) {
            this.paintItem(event, tableItem);
        }
    }

    private void paintItem(Event event, TableItem tableItem) {
        event.detail &= 0xFFFFFFDF;
        if (TableMergeViewer.isSelected(event)) {
            Rectangle fill = TableMergeViewer.getBounds(tableItem);
            TableMergeViewer.drawSelectionBox(event, fill);
        }
    }

    private void paintItemDiffBox(Event event, Diff diff, Rectangle bounds) {
        event.detail &= 0xFFFFFFDF;
        if (diff.getState() == DifferenceState.DISCARDED || diff.getState() == DifferenceState.MERGED) {
            return;
        }
        GC g = event.gc;
        Color oldBackground = g.getBackground();
        Color oldForeground = g.getForeground();
        this.setDiffColorsToGC(g, diff, TableMergeViewer.isSelected(event));
        g.fillRectangle(bounds);
        g.drawRectangle(bounds);
        if (TableMergeViewer.isSelected(event)) {
            g.setForeground(event.display.getSystemColor(24));
            g.setBackground(event.display.getSystemColor(25));
            event.detail &= 0xFFFFFFFD;
        } else {
            g.setBackground(oldBackground);
            g.setForeground(oldForeground);
        }
    }

    private static boolean isSelected(Event event) {
        return (event.detail & 2) != 0;
    }

    private static void drawSelectionBox(Event event, Rectangle fill) {
        Display display = event.display;
        GC g = event.gc;
        g.setBackground(display.getSystemColor(26));
        g.setForeground(display.getSystemColor(27));
        g.fillRectangle(fill);
        event.detail &= 0xFFFFFFFD;
    }

    private static Rectangle getBounds(TableItem tableItem) {
        Rectangle tableBounds = tableItem.getParent().getBounds();
        Rectangle itemBounds = tableItem.getBounds();
        Rectangle fill = new Rectangle(0, 0, 0, 0);
        fill.x = 2;
        fill.y = itemBounds.y + 2;
        fill.width = tableBounds.width - 6;
        fill.height = itemBounds.height - 3;
        return fill;
    }

    private static Rectangle getBoundsForInsertionPoint(TableItem tableItem) {
        Rectangle fill = TableMergeViewer.getBounds(tableItem);
        fill.y += 6;
        fill.height -= 12;
        return fill;
    }

    private void setDiffColorsToGC(GC g, Diff diff, boolean selected) {
        g.setForeground(this.fContentMergeViewer.getColors().getStrokeColor(diff, this.fContentMergeViewer.isThreeWay(), false, selected));
        g.setBackground(this.fContentMergeViewer.getColors().getFillColor(diff, this.fContentMergeViewer.isThreeWay(), false, selected));
    }
}

