/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree;

import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.EMFCompareContentMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.IMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree.TreeMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree.TreeMergeViewerContentProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeContentMergeViewer
extends EMFCompareContentMergeViewer {
    private static final String BUNDLE_NAME = TreeContentMergeViewer.class.getName();
    private final AdapterFactory fAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);

    public TreeContentMergeViewer(Composite parent, CompareConfiguration config) {
        super(0, ResourceBundle.getBundle(BUNDLE_NAME), config);
        this.buildControl(parent);
        this.setContentProvider((IContentProvider)new TreeMergeViewerContentProvider(config));
    }

    protected IMergeViewer<Tree> getAncestorMergeViewer() {
        return super.getAncestorMergeViewer();
    }

    protected IMergeViewer<Tree> getLeftMergeViewer() {
        return super.getLeftMergeViewer();
    }

    protected IMergeViewer<Tree> getRightMergeViewer() {
        return super.getRightMergeViewer();
    }

    protected void copy(boolean leftToRight) {
        System.out.println("TreeContentMergeViewer.copy()");
    }

    @Override
    protected void copyDiffLeftToRight() {
        IStructuredSelection selection = (IStructuredSelection)this.getLeftMergeViewer().getSelection();
        Object firstElement = selection.getFirstElement();
        EList differences = this.getComparison().getDifferences((EObject)firstElement);
        for (Diff diff : differences) {
            if (diff.getSource() != DifferenceSource.LEFT) continue;
            diff.copyLeftToRight();
        }
    }

    @Override
    protected void copyDiffRightToLeft() {
        IStructuredSelection selection = (IStructuredSelection)this.getRightMergeViewer().getSelection();
        Object firstElement = selection.getFirstElement();
        EList differences = this.getComparison().getDifferences((EObject)firstElement);
        for (Diff diff : differences) {
            if (diff.getSource() != DifferenceSource.RIGHT) continue;
            diff.copyRightToLeft();
        }
    }

    protected byte[] getContents(boolean left) {
        return null;
    }

    protected IMergeViewer<Tree> createMergeViewer(Composite parent, IMergeViewer.MergeViewerSide side) {
        TreeMergeViewer mergeTreeViewer = new TreeMergeViewer(parent, side);
        AdapterFactoryContentProvider contentProvider = new AdapterFactoryContentProvider(this.fAdapterFactory);
        mergeTreeViewer.setContentProvider((IContentProvider)contentProvider);
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider(this.fAdapterFactory);
        mergeTreeViewer.setLabelProvider((ILabelProvider)labelProvider);
        return mergeTreeViewer;
    }

    @Override
    protected void paintCenter(Canvas canvas, GC g) {
    }
}

