/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree;

import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.AbstractMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.IMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.provider.IEObjectAccessor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TreeMergeViewer
extends AbstractMergeViewer<Tree> {
    private IEObjectAccessor fInput;

    public TreeMergeViewer(Composite parent, IMergeViewer.MergeViewerSide side) {
        super(parent, side);
    }

    @Override
    public Tree getControl() {
        return this.getStructuredViewer().getTree();
    }

    protected TreeViewer getStructuredViewer() {
        return (TreeViewer)super.getStructuredViewer();
    }

    @Override
    protected StructuredViewer createStructuredViewer(Composite parent) {
        return new TreeViewer(parent);
    }

    @Override
    public void setSelection(Object input) {
        if (input instanceof IEObjectAccessor) {
            Object viewerInput;
            EObject eObject = ((IEObjectAccessor)input).getEObject();
            Object selection = viewerInput = TreeMergeViewer.doGetInput(eObject);
            if (eObject != null) {
                if (eObject.eContainer() == viewerInput) {
                    selection = eObject;
                } else if (eObject.eContainer() == null) {
                    selection = eObject;
                }
            }
            this.getStructuredViewer().setSelection((ISelection)new StructuredSelection(selection));
            this.getStructuredViewer().expandToLevel(selection, 1);
        }
    }

    @Override
    public void setSelection(Match match) {
        EObject eObject;
        switch (this.getSide()) {
            case ANCESTOR: {
                eObject = match.getOrigin();
                break;
            }
            case LEFT: {
                eObject = match.getLeft();
                break;
            }
            case RIGHT: {
                eObject = match.getRight();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        StructuredSelection selection = eObject != null ? new StructuredSelection((Object)eObject) : StructuredSelection.EMPTY;
        this.setSelection((ISelection)selection);
    }

    @Override
    public void setInput(Object input) {
        if (input instanceof IEObjectAccessor) {
            this.fInput = (IEObjectAccessor)input;
            EObject eObject = ((IEObjectAccessor)input).getEObject();
            Object viewerInput = TreeMergeViewer.doGetInput(eObject);
            this.getStructuredViewer().setInput(viewerInput);
            Object selection = viewerInput;
            if (eObject != null) {
                if (eObject.eContainer() == viewerInput) {
                    selection = eObject;
                } else if (eObject.eContainer() == null) {
                    selection = eObject;
                }
            }
            this.getStructuredViewer().setSelection((ISelection)new StructuredSelection(selection));
            this.getStructuredViewer().expandToLevel(selection, 1);
        } else {
            this.getStructuredViewer().setInput(null);
        }
    }

    public Object getInput() {
        return this.fInput;
    }

    private static Object doGetInput(EObject eObject) {
        Object input = null;
        if (eObject != null) {
            input = eObject.eContainer() != null ? eObject.eContainer() : eObject.eResource();
        }
        return input;
    }
}

