/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractBufferedCanvas
extends Canvas {
    protected Image buffer;

    public AbstractBufferedCanvas(Composite parent, int flags) {
        super(parent, flags | 0x40000);
        final PaintListener paintListener = new PaintListener(){

            public void paintControl(PaintEvent event) {
                AbstractBufferedCanvas.this.doubleBufferedPaint(event.gc);
            }
        };
        this.addPaintListener(paintListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AbstractBufferedCanvas.this.buffer != null) {
                    AbstractBufferedCanvas.this.buffer.dispose();
                    AbstractBufferedCanvas.this.buffer = null;
                }
                AbstractBufferedCanvas.this.removePaintListener(paintListener);
            }
        });
    }

    public void dispose() {
        super.dispose();
        if (this.buffer != null) {
            this.buffer.dispose();
        }
    }

    void doubleBufferedPaint(GC dest) {
        Point size = this.getSize();
        if (size.x <= 1 || size.y <= 1) {
            return;
        }
        if (this.buffer != null) {
            Rectangle bufferBounds = this.buffer.getBounds();
            if (bufferBounds.width != size.x || bufferBounds.height != size.y) {
                this.buffer.dispose();
                this.buffer = null;
            }
        }
        if (this.buffer == null) {
            this.buffer = new Image((Device)this.getDisplay(), size.x, size.y);
        }
        GC gc = new GC((Drawable)this.buffer);
        try {
            gc.setBackground(this.getBackground());
            gc.fillRectangle(0, 0, size.x, size.y);
            this.doPaint(gc);
        }
        finally {
            gc.dispose();
        }
        dest.drawImage(this.buffer, 0, 0);
    }

    public abstract void doPaint(GC var1);
}

