/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.CompareConfigurationExtension;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFCompareColor
implements RemovalListener<RGB, Color> {
    private RGB fIncomingSelected;
    private RGB fIncoming;
    private RGB fIncomingFill;
    private RGB fIncomingTextFill;
    private RGB fConflictSelected;
    private RGB fConflict;
    private RGB fConflictFill;
    private RGB fConflictTextFill;
    private RGB fOutgoingSelected;
    private RGB fOutgoing;
    private RGB fOutgoingFill;
    private RGB fOutgoingTextFill;
    private RGB fResolved;
    private final Cache<RGB, Color> fColors;
    private final ContentMergeViewer fContentMergeViewer;
    private final IPreferenceStore fPreferenceStore;
    private final IPropertyChangeListener fPreferenceChangeListener;
    private final IPropertyChangeListener fCompareConfigurationChangeListener;
    private final boolean fLeftIsLocal;
    private boolean fMergeTipRightToLeft;
    private final CompareConfiguration fCompareConfiguration;

    public EMFCompareColor(ContentMergeViewer contentMergeViewer, IPreferenceStore preferenceStore, CompareConfiguration compareConfiguration) {
        this.fContentMergeViewer = contentMergeViewer;
        this.fPreferenceStore = preferenceStore;
        this.fCompareConfiguration = compareConfiguration;
        this.fColors = CacheBuilder.newBuilder().maximumSize(16).removalListener((RemovalListener)this).build((CacheLoader)new CacheLoader<RGB, Color>(){

            public Color load(RGB rgb) throws Exception {
                return new Color((Device)EMFCompareColor.this.getDisplay(), rgb);
            }
        });
        this.fPreferenceChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                EMFCompareColor.this.handlePropertyChangeEvent(event);
            }
        };
        this.fCompareConfigurationChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                EMFCompareColor.this.handlePropertyChangeEvent(event);
            }
        };
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener(this.fPreferenceChangeListener);
        }
        compareConfiguration.addPropertyChangeListener(this.fCompareConfigurationChangeListener);
        this.fMergeTipRightToLeft = CompareConfigurationExtension.getBoolean(compareConfiguration, "org.eclipse.emf.compare.ide.ui.MERGE_TIP_RIGHT_TO_LEFT", true);
        this.fLeftIsLocal = CompareConfigurationExtension.getBoolean(compareConfiguration, "LEFT_IS_LOCAL", false);
        this.updateColors();
    }

    private Display getDisplay() {
        return this.fContentMergeViewer.getControl().getDisplay();
    }

    public void onRemoval(RemovalNotification<RGB, Color> notification) {
        Color color = (Color)notification.getValue();
        if (!color.isDisposed()) {
            color.dispose();
        }
    }

    private void handlePropertyChangeEvent(PropertyChangeEvent event) {
        String key = event.getProperty();
        if (key.equals("INCOMING_COLOR") || key.equals("OUTGOING_COLOR") || key.equals("CONFLICTING_COLOR") || key.equals("RESOLVED_COLOR")) {
            this.updateColors();
        }
        if (key.equals("org.eclipse.emf.compare.ide.ui.MERGE_TIP_RIGHT_TO_LEFT")) {
            this.fMergeTipRightToLeft = CompareConfigurationExtension.getBoolean(this.fCompareConfiguration, "org.eclipse.emf.compare.ide.ui.MERGE_TIP_RIGHT_TO_LEFT", true);
        }
    }

    private Color getColor(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        Color c = (Color)this.fColors.getUnchecked((Object)rgb);
        return c;
    }

    public Color getFillColor(Diff diff, boolean isThreeWay, boolean isIgnoreAncestor, boolean selected) {
        return this.getColor(this.getFillRGB(diff, isThreeWay, isIgnoreAncestor, selected));
    }

    private RGB getFillRGB(Diff diff, boolean isThreeWay, boolean isIgnoreAncestor, boolean selected) {
        RGB selected_fill = this.getBackground();
        if (isThreeWay && !isIgnoreAncestor) {
            boolean requiredConflictForWayOfMerge = false;
            if (diff.getConflict() == null && !requiredConflictForWayOfMerge) {
                switch (diff.getSource()) {
                    case RIGHT: {
                        if (this.fLeftIsLocal) {
                            return selected ? selected_fill : this.fIncomingFill;
                        }
                        return selected ? selected_fill : this.fOutgoingFill;
                    }
                    case LEFT: {
                        if (this.fLeftIsLocal) {
                            return selected ? selected_fill : this.fOutgoingFill;
                        }
                        return selected ? selected_fill : this.fIncomingFill;
                    }
                }
            } else {
                return selected ? selected_fill : this.fConflictFill;
            }
            return selected ? selected_fill : this.fConflictFill;
        }
        return selected ? selected_fill : this.fOutgoingFill;
    }

    public Color getStrokeColor(Diff diff, boolean isThreeWay, boolean isIgnoreAncestor, boolean selected) {
        return this.getColor(this.getStrokeRGB(diff, isThreeWay, isIgnoreAncestor, selected));
    }

    private RGB getStrokeRGB(Diff diff, boolean isThreeWay, boolean isIgnoreAncestor, boolean selected) {
        if (isThreeWay && !isIgnoreAncestor) {
            boolean requiredConflictForWayOfMerge = false;
            if (diff.getConflict() == null && !requiredConflictForWayOfMerge) {
                switch (diff.getSource()) {
                    case RIGHT: {
                        if (this.fLeftIsLocal) {
                            return selected ? this.fIncomingSelected : this.fIncoming;
                        }
                        return selected ? this.fOutgoingSelected : this.fOutgoing;
                    }
                    case LEFT: {
                        if (this.fLeftIsLocal) {
                            return selected ? this.fOutgoingSelected : this.fOutgoing;
                        }
                        return selected ? this.fIncomingSelected : this.fIncoming;
                    }
                }
            } else {
                return selected ? this.fConflictSelected : this.fConflict;
            }
            return selected ? this.fConflictSelected : this.fConflict;
        }
        return selected ? this.fOutgoingSelected : this.fOutgoing;
    }

    private RGB getBackground() {
        return this.getDisplay().getSystemColor(25).getRGB();
    }

    private void updateColors() {
        ColorRegistry registry = JFaceResources.getColorRegistry();
        RGB bg = this.getBackground();
        this.fIncomingSelected = registry.getRGB("INCOMING_COLOR");
        if (this.fIncomingSelected == null) {
            this.fIncomingSelected = new RGB(0, 0, 255);
        }
        this.fIncoming = EMFCompareColor.interpolate(this.fIncomingSelected, bg, 0.6);
        this.fIncomingFill = EMFCompareColor.interpolate(this.fIncomingSelected, bg, 0.97);
        this.fIncomingTextFill = EMFCompareColor.interpolate(this.fIncomingSelected, bg, 0.85);
        this.fOutgoingSelected = registry.getRGB("OUTGOING_COLOR");
        if (this.fOutgoingSelected == null) {
            this.fOutgoingSelected = new RGB(0, 0, 0);
        }
        this.fOutgoing = EMFCompareColor.interpolate(this.fOutgoingSelected, bg, 0.6);
        this.fOutgoingFill = EMFCompareColor.interpolate(this.fOutgoingSelected, bg, 0.97);
        this.fOutgoingTextFill = EMFCompareColor.interpolate(this.fOutgoingSelected, bg, 0.85);
        this.fConflictSelected = registry.getRGB("CONFLICTING_COLOR");
        if (this.fConflictSelected == null) {
            this.fConflictSelected = new RGB(255, 0, 0);
        }
        this.fConflict = EMFCompareColor.interpolate(this.fConflictSelected, bg, 0.6);
        this.fConflictFill = EMFCompareColor.interpolate(this.fConflictSelected, bg, 0.97);
        this.fConflictTextFill = EMFCompareColor.interpolate(this.fConflictSelected, bg, 0.85);
        this.fResolved = registry.getRGB("RESOLVED_COLOR");
        if (this.fResolved == null) {
            this.fResolved = new RGB(0, 255, 0);
        }
    }

    private static RGB interpolate(RGB fg, RGB bg, double scale) {
        if (fg != null && bg != null) {
            return new RGB((int)((1.0 - scale) * (double)fg.red + scale * (double)bg.red), (int)((1.0 - scale) * (double)fg.green + scale * (double)bg.green), (int)((1.0 - scale) * (double)fg.blue + scale * (double)bg.blue));
        }
        if (fg != null) {
            return fg;
        }
        if (bg != null) {
            return bg;
        }
        return new RGB(128, 128, 128);
    }

    public void dispose() {
        this.fColors.invalidateAll();
        this.fPreferenceStore.removePropertyChangeListener(this.fPreferenceChangeListener);
        this.fCompareConfiguration.removePropertyChangeListener(this.fCompareConfigurationChangeListener);
    }
}

