/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.structuremergeviewer.DiffTreeViewer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.ComparePackage;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.actions.filter.DifferenceFilter;
import org.eclipse.emf.compare.ide.ui.internal.actions.filter.FilterActionMenu;
import org.eclipse.emf.compare.ide.ui.internal.actions.group.DifferenceGrouper;
import org.eclipse.emf.compare.ide.ui.internal.actions.group.GroupActionMenu;
import org.eclipse.emf.compare.ide.ui.internal.actions.mergeway.MergeWayAction;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.CompareConfigurationExtension;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.AbstractEDiffElement;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewerLabelProvider;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.CompareNodeAdapterFactory;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.ComparisonNode;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class EMFCompareStructureMergeViewer
extends DiffTreeViewer {
    private final ICompareInputChangeListener fCompareInputChangeListener;
    private final ComposedAdapterFactory fAdapterFactory;
    private IContentChangeListener fContentChangedListener;
    private final SideInputInfo fAncestorStructure = new SideInputInfo();
    private final SideInputInfo fLeftStructure = new SideInputInfo();
    private final SideInputInfo fRightStructure = new SideInputInfo();
    private final CompareViewerSwitchingPane fParent;
    private Object fRoot;
    private DifferenceFilter differenceFilter;
    private DifferenceGrouper differenceGrouper;
    private IRunnableWithProgress inputChangedTask = new IRunnableWithProgress(){

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask("Computing Structure Differences", 100);
            EMFCompareStructureMergeViewer.this.compareInputChanged((ICompareInput)EMFCompareStructureMergeViewer.this.getInput(), true, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            monitor.done();
        }
    };
    private ToolBarManager fToolbarManager;

    public EMFCompareStructureMergeViewer(Composite parent, CompareConfiguration configuration) {
        super(parent, configuration);
        this.differenceFilter.install((TreeViewer)this);
        this.differenceGrouper.install((TreeViewer)this);
        this.fAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new CompareNodeAdapterFactory(this.differenceGrouper));
        boolean leftIsLocal = CompareConfigurationExtension.getBoolean(configuration, "LEFT_IS_LOCAL", false);
        this.setLabelProvider((IBaseLabelProvider)new EMFCompareStructureMergeViewerLabelProvider((AdapterFactory)this.fAdapterFactory, leftIsLocal));
        this.fParent = parent instanceof CompareViewerSwitchingPane ? (CompareViewerSwitchingPane)parent : null;
        this.fContentChangedListener = new IContentChangeListener(){

            public void contentChanged(IContentChangeNotifier changed) {
                EMFCompareStructureMergeViewer.this.contentChanged(changed);
            }
        };
        this.fCompareInputChangeListener = new ICompareInputChangeListener(){

            public void compareInputChanged(ICompareInput input) {
                EMFCompareStructureMergeViewer.this.compareInputChanged(input, true);
            }
        };
        this.setComparer(new DiffNodeComparer(super.getComparer()));
    }

    void compareInputChanged(ICompareInput input, boolean force) {
        if (input == null) {
            this.compareInputChanged(input, force, null);
            return;
        }
        CompareConfiguration cc = this.getCompareConfiguration();
        if (cc != null) {
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        EMFCompareStructureMergeViewer.this.inputChangedTask.run((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (InvocationTargetException e) {
                        CompareUIPlugin.log((Throwable)e.getTargetException());
                    }
                    catch (InterruptedException interruptedException) {}
                }
            });
        }
    }

    protected Object getRoot() {
        return this.fRoot;
    }

    protected void contentChanged(IContentChangeNotifier changed) {
    }

    void compareInputChanged(ICompareInput input, boolean force, IProgressMonitor monitor) {
        ITypedElement t = null;
        if (input != null) {
            t = input.getAncestor();
        }
        this.fAncestorStructure.setInput(t, force);
        if (input != null) {
            t = input.getLeft();
        }
        this.fLeftStructure.setInput(t, force);
        if (input != null) {
            t = input.getRight();
        }
        this.fRightStructure.setInput(t, force);
        Object previousResult = this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.ide.ui.COMPARE.RESULT");
        if (previousResult instanceof Comparison) {
            this.fRoot = (Comparison)previousResult;
            this.getCompareConfiguration().getContainer().runAsynchronously(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (Display.getCurrent() != null) {
                        EMFCompareStructureMergeViewer.this.refreshAfterDiff("my message", EMFCompareStructureMergeViewer.this.fRoot);
                    } else {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                EMFCompareStructureMergeViewer.this.refreshAfterDiff("my message", EMFCompareStructureMergeViewer.this.fRoot);
                            }
                        });
                    }
                }
            });
        } else if (input != null) {
            ResourceSet leftResourceSet = EMFCompareStructureMergeViewer.getResourceSetFrom(input.getLeft(), monitor);
            ResourceSet rightResourceSet = EMFCompareStructureMergeViewer.getResourceSetFrom(input.getRight(), monitor);
            ResourceSet ancestorResourceSet = EMFCompareStructureMergeViewer.getResourceSetFrom(input.getAncestor(), monitor);
            EMFCompareConfiguration emfCompareConfiguration = EMFCompareConfiguration.builder().build();
            Comparison compareResult = EMFCompare.compare((Notifier)leftResourceSet, (Notifier)rightResourceSet, (Notifier)ancestorResourceSet, (EMFCompareConfiguration)emfCompareConfiguration);
            compareResult.eAdapters().add((Object)new EContentAdapter(){

                public void notifyChanged(Notification notification) {
                    int eventType = notification.getEventType();
                    Object feature = notification.getFeature();
                    Object oldValue = notification.getOldValue();
                    Object newValue = notification.getNewValue();
                    if (eventType == 1 && feature == ComparePackage.Literals.DIFF__STATE && oldValue == DifferenceState.UNRESOLVED && (newValue == DifferenceState.MERGED || newValue == DifferenceState.DISCARDED)) {
                        EMFCompareStructureMergeViewer.this.refresh();
                    }
                }
            });
            this.fRoot = this.fAdapterFactory.adapt((Notifier)compareResult, IDiffElement.class);
            this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.ide.ui.COMPARE.RESULT", this.fRoot);
            this.getCompareConfiguration().getContainer().runAsynchronously(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (Display.getCurrent() != null) {
                        EMFCompareStructureMergeViewer.this.refreshAfterDiff("my message", EMFCompareStructureMergeViewer.this.fRoot);
                    } else {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                EMFCompareStructureMergeViewer.this.refreshAfterDiff("my message", EMFCompareStructureMergeViewer.this.fRoot);
                            }
                        });
                    }
                }
            });
        }
    }

    private void refreshAfterDiff(String message, Object root) {
        if (this.getControl().isDisposed()) {
            return;
        }
        if (this.fRoot instanceof ComparisonNode && !((ComparisonNode)((Object)this.fRoot)).getTarget().isThreeWay()) {
            this.fToolbarManager.remove(MergeWayAction.class.getName());
            this.fToolbarManager.update(true);
        }
        if (this.fParent != null) {
            this.fParent.setTitleArgument(message);
        }
        this.refresh(root);
    }

    protected void compareInputChanged(ICompareInput input) {
        this.compareInputChanged(input, false);
    }

    public void setComparer(IElementComparer comparer) {
        super.setComparer((IElementComparer)new DiffNodeComparer(comparer));
    }

    protected void createToolItems(ToolBarManager toolbarManager) {
        this.fToolbarManager = toolbarManager;
        super.createToolItems(toolbarManager);
        this.fToolbarManager.add((IAction)new MergeWayAction(this.getCompareConfiguration()));
        if (this.differenceFilter == null) {
            this.differenceFilter = new DifferenceFilter();
        }
        if (this.differenceGrouper == null) {
            this.differenceGrouper = new DifferenceGrouper();
        }
        this.fToolbarManager.add((IAction)new GroupActionMenu(this.differenceGrouper));
        this.fToolbarManager.add((IAction)new FilterActionMenu(this.differenceFilter));
    }

    protected void inputChanged(Object input, Object oldInput) {
        if (oldInput instanceof ICompareInput) {
            ICompareInput old = (ICompareInput)oldInput;
            old.removeCompareInputChangeListener(this.fCompareInputChangeListener);
        }
        if (input instanceof ICompareInput) {
            ICompareInput ci = (ICompareInput)input;
            ci.addCompareInputChangeListener(this.fCompareInputChangeListener);
            this.compareInputChanged(ci);
            if (input != oldInput) {
                this.initialSelection();
            }
        }
    }

    protected void handleDispose(DisposeEvent event) {
        Object input = this.getInput();
        if (input instanceof ICompareInput) {
            ICompareInput ci = (ICompareInput)input;
            ci.removeCompareInputChangeListener(this.fCompareInputChangeListener);
        }
        this.compareInputChanged(null);
        this.fContentChangedListener = null;
        super.handleDispose(event);
    }

    private static ResourceSet getResourceSetFrom(ITypedElement typedElement, IProgressMonitor monitor) {
        ResourceSet resourceSet = null;
        if (typedElement instanceof IResourceProvider) {
            IResource resource = ((IResourceProvider)typedElement).getResource();
            resourceSet = EMFCompareStructureMergeViewer.getResourceSet(resource, monitor);
        }
        return resourceSet;
    }

    private static ResourceSet getResourceSet(IResource resource, IProgressMonitor monitor) {
        if (resource == null) {
            return null;
        }
        IModelProviderDescriptor[] descriptors = ModelProvider.getModelProviderDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            IModelProviderDescriptor descriptor = descriptors[i];
            try {
                IResource[] resources = descriptor.getMatchingResources(new IResource[]{resource});
                if (resources.length > 0) {
                    ModelProvider modelProvider = descriptor.getModelProvider();
                    ResourceMapping[] mappings = modelProvider.getMappings(resource, null, monitor);
                    modelProvider.getTraversals(mappings, null, monitor);
                    ResourceMapping[] resourceMappingArray = mappings;
                    int n = mappings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ResourceMapping resourceMapping = resourceMappingArray[n2];
                        if (resourceMapping.getModelObject() instanceof Resource) {
                            return ((Resource)resourceMapping.getModelObject()).getResourceSet();
                        }
                        ++n2;
                    }
                }
            }
            catch (CoreException e) {
                EMFCompareIDEUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "", e.getMessage(), (Throwable)e));
            }
            ++i;
        }
        return null;
    }

    private class DiffNodeComparer
    implements IElementComparer {
        private IElementComparer delegate;

        public DiffNodeComparer(IElementComparer delegate) {
            this.delegate = delegate;
        }

        public boolean equals(Object a, Object b) {
            Notifier targetA;
            boolean equal = a instanceof AbstractEDiffElement && b instanceof AbstractEDiffElement ? ((targetA = ((AbstractEDiffElement)((Object)a)).getTarget()) == null ? a.equals(b) : targetA.equals(((AbstractEDiffElement)((Object)b)).getTarget())) : (this.delegate != null ? this.delegate.equals(a, b) : (a != null ? a.equals(b) : a == b));
            return equal;
        }

        public int hashCode(Object element) {
            Notifier target;
            int hashCode = element instanceof AbstractEDiffElement ? ((target = ((AbstractEDiffElement)((Object)element)).getTarget()) == null ? element.hashCode() : target.hashCode()) : (this.delegate != null ? this.delegate.hashCode(element) : (element != null ? element.hashCode() : 0));
            return hashCode;
        }
    }

    private class SideInputInfo {
        private ITypedElement fInput;

        private SideInputInfo() {
        }

        public boolean setInput(ITypedElement newInput, boolean force) {
            boolean changed = false;
            if (force || newInput != this.fInput) {
                boolean bl = changed = newInput != null;
                if (this.fInput instanceof IContentChangeNotifier && EMFCompareStructureMergeViewer.this.fContentChangedListener != null) {
                    ((IContentChangeNotifier)this.fInput).removeContentChangeListener(EMFCompareStructureMergeViewer.this.fContentChangedListener);
                }
                this.fInput = newInput;
                if (this.fInput instanceof IContentChangeNotifier && EMFCompareStructureMergeViewer.this.fContentChangedListener != null) {
                    ((IContentChangeNotifier)this.fInput).addContentChangeListener(EMFCompareStructureMergeViewer.this.fContentChangedListener);
                }
            }
            return changed;
        }
    }
}

