/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.AbstractEDiffElement;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.DiffNode;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.ImageProvider;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.MatchNode;
import org.eclipse.emf.compare.ide.ui.internal.util.EMFCompareCompositeImageDescriptor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

class EMFCompareStructureMergeViewerLabelProvider
extends AdapterFactoryLabelProvider {
    private final boolean fLeftIsLocal;
    private final ImageProvider imgProvider;

    public EMFCompareStructureMergeViewerLabelProvider(AdapterFactory adapterFactory, boolean leftIsLocal) {
        super(adapterFactory);
        this.fLeftIsLocal = leftIsLocal;
        this.imgProvider = new ImageProvider(this.fLeftIsLocal);
    }

    public String getText(Object element) {
        if (element instanceof IDiffElement) {
            return ((IDiffElement)element).getName();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        Image ret;
        if (element instanceof DiffNode) {
            Diff target = ((DiffNode)((Object)element)).getTarget();
            ImageDescriptor overlay = this.imgProvider.getImageDescriptorOverlay(target);
            Image base = super.getImage((Object)target);
            EMFCompareCompositeImageDescriptor descriptor = new EMFCompareCompositeImageDescriptor(base, overlay, 22, !this.fLeftIsLocal);
            ret = EMFCompareIDEUIPlugin.getDefault().getImage((ImageDescriptor)descriptor);
        } else if (element instanceof MatchNode) {
            Match target = ((MatchNode)((Object)element)).getTarget();
            ImageDescriptor overlay = this.imgProvider.getImageDescriptorOverlay(target);
            Image base = super.getImage((Object)target);
            EMFCompareCompositeImageDescriptor descriptor = new EMFCompareCompositeImageDescriptor(base, overlay, 22, !this.fLeftIsLocal);
            ret = EMFCompareIDEUIPlugin.getDefault().getImage((ImageDescriptor)descriptor);
        } else {
            ret = element instanceof AbstractEDiffElement ? ((AbstractEDiffElement)((Object)element)).getImage() : super.getImage(element);
        }
        return ret;
    }
}

