/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider.spec;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.provider.ReferenceChangeItemProvider;
import org.eclipse.emf.compare.provider.spec.CompareItemProviderAdapterFactorySpec;
import org.eclipse.emf.compare.provider.spec.Strings;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceChangeItemProviderSpec
extends ReferenceChangeItemProvider {
    public ReferenceChangeItemProviderSpec(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public String getText(Object object) {
        ReferenceChange refChange = (ReferenceChange)object;
        String valueText = this.getValueText(refChange);
        String referenceText = this.getReferenceText(refChange);
        String remotely = "";
        if (refChange.getSource() == DifferenceSource.RIGHT) {
            remotely = "remotely ";
        }
        String ret = "";
        switch (refChange.getKind()) {
            case ADD: {
                ret = String.valueOf(valueText) + " has been " + remotely + "added to " + referenceText;
                break;
            }
            case DELETE: {
                ret = String.valueOf(valueText) + " has been " + remotely + "deleted from " + referenceText;
                break;
            }
            case CHANGE: {
                ret = String.valueOf(referenceText) + " " + valueText + " has been " + remotely + "changed";
                break;
            }
            case MOVE: {
                ret = String.valueOf(valueText) + " has been " + remotely + "moved in " + referenceText;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + refChange.getKind());
            }
        }
        return ret;
    }

    protected String getReferenceText(ReferenceChange refChange) {
        return refChange.getReference().getName();
    }

    protected String getValueText(ReferenceChange refChange) {
        String value = CompareItemProviderAdapterFactorySpec.getText(this.getRootAdapterFactory(), refChange.getValue());
        value = value == null ? "<null>" : Strings.elide(value, 20, "...");
        return value;
    }

    @Override
    public Object getImage(Object object) {
        ReferenceChange refChange = (ReferenceChange)object;
        Object image = CompareItemProviderAdapterFactorySpec.getImage(this.getRootAdapterFactory(), refChange.getValue());
        return image;
    }

    public Collection<?> getChildren(Object object) {
        ITreeItemContentProvider matchItemContentProvider;
        Match match;
        Collection superChildren = super.getChildren(object);
        ArrayList ret = Lists.newArrayList((Iterable)superChildren);
        ReferenceChange referenceChange = (ReferenceChange)object;
        EReference reference = referenceChange.getReference();
        if (reference.isContainment() && (match = referenceChange.getMatch().getComparison().getMatch(referenceChange.getValue())) != null && (matchItemContentProvider = (ITreeItemContentProvider)this.adapterFactory.adapt((Notifier)match, ITreeItemContentProvider.class)) != null) {
            ArrayList children = Lists.newArrayList((Iterable)matchItemContentProvider.getChildren((Object)match));
            children.remove(referenceChange);
            Iterator childrenIterator = children.iterator();
            while (childrenIterator.hasNext()) {
                Object child = childrenIterator.next();
                if (!(child instanceof Match) || matchItemContentProvider.hasChildren(child)) continue;
                childrenIterator.remove();
            }
            ret.addAll(children);
        }
        return ret;
    }
}

