/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.internal.extension;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.compare.ide.logical.extension.IModelResolver;
import org.eclipse.emf.compare.internal.ModelIdentifier;

public class ModelResolverDescriptor {
    public static final String MODEL_RESOLVER_CLASS_ATTRIBUTE = "class";
    public static final String MODEL_RESOLVER_FILE_EXTENSION_TAG = "fileExtension";
    public static final String MODEL_RESOLVER_CONTENT_TYPE_TAG = "contentType";
    public static final String MODEL_RESOLVER_NAMESPACE_TAG = "namespace";
    public static final String ENABLEMENT_TAG_VALUE = "value";
    public static final String VALUE_SEPARATOR = ",";
    private final IConfigurationElement element;
    private final String extensionClassName;
    private final String contentType;
    private final String fileExtension;
    private final String namespace;
    private IModelResolver modelResolver;

    public ModelResolverDescriptor(IConfigurationElement element) {
        this.element = element;
        this.extensionClassName = element.getAttribute(MODEL_RESOLVER_CLASS_ATTRIBUTE);
        IConfigurationElement[] contentTypeConfig = element.getChildren(MODEL_RESOLVER_CONTENT_TYPE_TAG);
        this.contentType = contentTypeConfig.length > 0 ? contentTypeConfig[0].getAttribute(ENABLEMENT_TAG_VALUE) : null;
        IConfigurationElement[] fileExtensionConfig = element.getChildren(MODEL_RESOLVER_FILE_EXTENSION_TAG);
        this.fileExtension = fileExtensionConfig.length > 0 ? fileExtensionConfig[0].getAttribute(ENABLEMENT_TAG_VALUE) : null;
        IConfigurationElement[] namespaceConfig = element.getChildren(MODEL_RESOLVER_NAMESPACE_TAG);
        this.namespace = namespaceConfig.length > 0 ? namespaceConfig[0].getAttribute(ENABLEMENT_TAG_VALUE) : null;
    }

    public String getExtensionClassName() {
        return this.extensionClassName;
    }

    public IModelResolver getModelResolver() {
        if (this.modelResolver == null) {
            try {
                this.modelResolver = (IModelResolver)this.element.createExecutableExtension(MODEL_RESOLVER_CLASS_ATTRIBUTE);
            }
            catch (CoreException coreException) {}
        }
        return this.modelResolver;
    }

    public boolean canResolve(ModelIdentifier identifier) {
        boolean canResolve = identifier.matchExtension(this.fileExtension);
        if (!canResolve) {
            canResolve = identifier.matchNamespace(this.namespace);
        }
        return canResolve;
    }
}

