/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare;

import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompareConfiguration;
import org.eclipse.emf.compare.conflict.DefaultConflictDetector;
import org.eclipse.emf.compare.diff.DefaultDiffEngine;
import org.eclipse.emf.compare.diff.DiffBuilder;
import org.eclipse.emf.compare.equi.DefaultEquiEngine;
import org.eclipse.emf.compare.logical.extension.EMFCompareExtensionRegistry;
import org.eclipse.emf.compare.logical.extension.IPostProcessor;
import org.eclipse.emf.compare.logical.extension.PostProcessorDescriptor;
import org.eclipse.emf.compare.match.DefaultMatchEngine;
import org.eclipse.emf.compare.req.DefaultReqEngine;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class EMFCompare {
    private EMFCompare() {
    }

    public static Comparison compare(Notifier left, Notifier right) {
        return EMFCompare.compare(left, right, null, EMFCompareConfiguration.builder().build());
    }

    public static Comparison compare(Notifier left, Notifier right, EMFCompareConfiguration configuration) {
        return EMFCompare.compare(left, right, null, configuration);
    }

    public static Comparison compare(Notifier left, Notifier right, Notifier origin) {
        return EMFCompare.compare(left, right, origin, EMFCompareConfiguration.builder().build());
    }

    public static Comparison compare(Notifier left, Notifier right, Notifier origin, EMFCompareConfiguration configuration) {
        DefaultComparisonScope scope = new DefaultComparisonScope(left, right, origin);
        return EMFCompare.compare(scope, configuration);
    }

    public static Comparison compare(IComparisonScope scope) {
        return EMFCompare.compare(scope, EMFCompareConfiguration.builder().build());
    }

    public static Comparison compare(IComparisonScope scope, EMFCompareConfiguration configuration) {
        DefaultMatchEngine matchEngine = new DefaultMatchEngine();
        Comparison comparison = matchEngine.match(scope, configuration);
        IPostProcessor postProcessor = EMFCompare.getPostProcessor(scope);
        if (postProcessor != null) {
            postProcessor.postMatch(comparison);
        }
        DiffBuilder diffBuilder = new DiffBuilder();
        DefaultDiffEngine diffEngine = new DefaultDiffEngine(diffBuilder);
        diffEngine.diff(comparison);
        if (postProcessor != null) {
            postProcessor.postDiff(comparison);
        }
        EcoreUtil.CrossReferencer crossReferencer = ReferenceUtil.initializeCrossReferencer(comparison);
        DefaultReqEngine reqEngine = new DefaultReqEngine(crossReferencer);
        reqEngine.computeRequirements(comparison);
        if (postProcessor != null) {
            postProcessor.postRequirements(comparison, crossReferencer);
        }
        DefaultEquiEngine equiEngine = new DefaultEquiEngine(crossReferencer);
        equiEngine.computeEquivalences(comparison);
        if (postProcessor != null) {
            postProcessor.postEquivalences(comparison, crossReferencer);
        }
        if (comparison.isThreeWay()) {
            DefaultConflictDetector conflictDetector = new DefaultConflictDetector();
            conflictDetector.detect(comparison);
            if (postProcessor != null) {
                postProcessor.postConflicts(comparison);
            }
        }
        return comparison;
    }

    private static IPostProcessor getPostProcessor(IComparisonScope scope) {
        IPostProcessor postProcessor = null;
        block0: for (PostProcessorDescriptor descriptor : EMFCompareExtensionRegistry.getRegisteredPostProcessors()) {
            if (descriptor.getNsUri() != null && descriptor.getNsUri().trim().length() != 0) {
                Set<String> nsUris = scope.getNsURIs();
                for (String nsUri : nsUris) {
                    if (!nsUri.matches(descriptor.getNsUri())) continue;
                    postProcessor = descriptor.getPostProcessor();
                    break block0;
                }
            } else {
                if (descriptor.getResourceUri() == null || descriptor.getResourceUri().trim().length() == 0) continue;
                Set<String> resourceUris = scope.getResourceURIs();
                for (String resourceUri : resourceUris) {
                    if (!resourceUri.matches(descriptor.getResourceUri())) continue;
                    postProcessor = descriptor.getPostProcessor();
                    break block0;
                }
            }
            break;
        }
        return postProcessor;
    }
}

