/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare;

import com.google.common.base.Preconditions;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.utils.EqualityHelper;

public class EMFCompareConfiguration
extends AdapterImpl {
    private Monitor fMonitor;
    private EqualityHelper fEqualityHelper;

    EMFCompareConfiguration() {
    }

    public Monitor getMonitor() {
        return this.fMonitor;
    }

    public EqualityHelper getEqualityHelper() {
        return this.fEqualityHelper;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isAdapterForType(Object type) {
        return type == EMFCompareConfiguration.class;
    }

    public static class Builder {
        private Monitor fMonitor;
        private EqualityHelper fEqualityHelper;

        Builder() {
        }

        public Builder setMonitor(Monitor monitor) {
            Preconditions.checkNotNull((Object)monitor);
            this.fMonitor = monitor;
            return this;
        }

        public Builder setEqualityHelper(EqualityHelper equalityHelper) {
            Preconditions.checkNotNull((Object)equalityHelper);
            this.fEqualityHelper = equalityHelper;
            return this;
        }

        public EMFCompareConfiguration build() {
            EMFCompareConfiguration configuration = new EMFCompareConfiguration();
            if (this.fMonitor == null) {
                this.fMonitor = new BasicMonitor();
            }
            configuration.fMonitor = this.fMonitor;
            if (this.fEqualityHelper == null) {
                this.fEqualityHelper = new EqualityHelper();
            }
            configuration.fEqualityHelper = this.fEqualityHelper;
            return configuration;
        }
    }
}

