/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.diff.DiffBuilder;
import org.eclipse.emf.compare.diff.FeatureFilter;
import org.eclipse.emf.compare.diff.IDiffEngine;
import org.eclipse.emf.compare.diff.IDiffProcessor;
import org.eclipse.emf.compare.utils.DiffUtil;
import org.eclipse.emf.compare.utils.EqualityHelper;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDiffEngine
implements IDiffEngine {
    protected static final Object UNMATCHED_VALUE = new Object();
    private Comparison currentComparison;
    private IDiffProcessor diffProcessor;
    private EqualityHelper helper;

    public DefaultDiffEngine() {
        this(new DiffBuilder());
    }

    public DefaultDiffEngine(IDiffProcessor processor) {
        this.diffProcessor = processor;
    }

    protected <E> Predicate<E> containedIn(final Comparison comparison, final Iterable<E> iterable) {
        return new Predicate<E>(){

            public boolean apply(E input) {
                return DefaultDiffEngine.this.contains(comparison, iterable, input);
            }
        };
    }

    protected <E> boolean contains(Comparison comparison, Iterable<E> iterable, E element) {
        for (E candidate : iterable) {
            if (!this.helper.matchingValues(comparison, candidate, element)) continue;
            return true;
        }
        return false;
    }

    protected static List<Object> getAsList(EObject object, EStructuralFeature feature) {
        if (object != null) {
            Object value = object.eGet(feature, false);
            ImmutableList asList = value instanceof List ? (ImmutableList)value : (value instanceof Iterable ? ImmutableList.copyOf((Iterable)((Iterable)value)) : (value != null ? ImmutableList.of((Object)value) : Collections.emptyList()));
            return asList;
        }
        return Collections.emptyList();
    }

    @Override
    public void diff(Comparison comparison) {
        this.currentComparison = comparison;
        this.helper = comparison.getConfiguration().getEqualityHelper();
        for (Match rootMatch : comparison.getMatches()) {
            this.checkForDifferences(rootMatch);
        }
    }

    protected void checkForDifferences(Match match) {
        FeatureFilter featureFilter = this.createFeatureFilter();
        Iterator<EReference> references = featureFilter.getReferencesToCheck(match);
        while (references.hasNext()) {
            EReference reference = references.next();
            boolean considerOrdering = featureFilter.checkForOrderingChanges((EStructuralFeature)reference);
            this.computeDifferences(match, reference, considerOrdering);
        }
        Iterator<EAttribute> attributes = featureFilter.getAttributesToCheck(match);
        while (attributes.hasNext()) {
            EAttribute attribute = attributes.next();
            boolean considerOrdering = featureFilter.checkForOrderingChanges((EStructuralFeature)attribute);
            this.computeDifferences(match, attribute, considerOrdering);
        }
        for (Match submatch : match.getSubmatches()) {
            this.checkForDifferences(submatch);
        }
    }

    protected void computeContainmentDifferencesThreeWay(Match match, EReference reference, boolean checkOrdering) {
        Match candidateMatch;
        List<Object> leftValues = DefaultDiffEngine.getAsList(match.getLeft(), (EStructuralFeature)reference);
        List<Object> rightValues = DefaultDiffEngine.getAsList(match.getRight(), (EStructuralFeature)reference);
        List<Object> originValues = DefaultDiffEngine.getAsList(match.getOrigin(), (EStructuralFeature)reference);
        List<Object> lcsOriginLeft = DiffUtil.longestCommonSubsequence(this.getComparison(), originValues, leftValues);
        List<Object> lcsOriginRight = DiffUtil.longestCommonSubsequence(this.getComparison(), originValues, rightValues);
        Iterable changedLeft = Iterables.filter(leftValues, (Predicate)Predicates.not(this.containedIn(this.getComparison(), lcsOriginLeft)));
        Iterable changedRight = Iterables.filter(rightValues, (Predicate)Predicates.not(this.containedIn(this.getComparison(), lcsOriginRight)));
        for (Object t : changedLeft) {
            candidateMatch = this.getComparison().getMatch((EObject)t);
            if (this.contains(this.getComparison(), originValues, t)) {
                if (!checkOrdering) continue;
                this.featureChange(match, (EStructuralFeature)reference, t, DifferenceKind.MOVE, DifferenceSource.LEFT);
                continue;
            }
            if (candidateMatch != null && candidateMatch.getOrigin() != null) {
                this.featureChange(match, (EStructuralFeature)reference, t, DifferenceKind.MOVE, DifferenceSource.LEFT);
                continue;
            }
            this.featureChange(match, (EStructuralFeature)reference, t, DifferenceKind.ADD, DifferenceSource.LEFT);
        }
        for (Object t : changedRight) {
            candidateMatch = this.getComparison().getMatch((EObject)t);
            if (this.contains(this.getComparison(), originValues, t)) {
                if (!checkOrdering) continue;
                this.featureChange(match, (EStructuralFeature)reference, t, DifferenceKind.MOVE, DifferenceSource.RIGHT);
                continue;
            }
            if (candidateMatch != null && candidateMatch.getOrigin() != null) {
                this.featureChange(match, (EStructuralFeature)reference, t, DifferenceKind.MOVE, DifferenceSource.RIGHT);
                continue;
            }
            this.featureChange(match, (EStructuralFeature)reference, t, DifferenceKind.ADD, DifferenceSource.RIGHT);
        }
        for (Object object : originValues) {
            candidateMatch = this.getComparison().getMatch((EObject)object);
            if (candidateMatch == null) continue;
            if (candidateMatch.getLeft() == null) {
                this.featureChange(match, (EStructuralFeature)reference, object, DifferenceKind.DELETE, DifferenceSource.LEFT);
            }
            if (candidateMatch.getRight() != null) continue;
            this.featureChange(match, (EStructuralFeature)reference, object, DifferenceKind.DELETE, DifferenceSource.RIGHT);
        }
    }

    protected void computeContainmentDifferencesTwoWay(Match match, EReference reference, boolean checkOrdering) {
        Match candidateMatch;
        List<Object> leftValues = DefaultDiffEngine.getAsList(match.getLeft(), (EStructuralFeature)reference);
        List<Object> rightValues = DefaultDiffEngine.getAsList(match.getRight(), (EStructuralFeature)reference);
        List<Object> lcs = DiffUtil.longestCommonSubsequence(this.getComparison(), rightValues, leftValues);
        Iterable changed = Iterables.filter(leftValues, (Predicate)Predicates.not(this.containedIn(this.getComparison(), lcs)));
        for (Object t : changed) {
            candidateMatch = this.getComparison().getMatch((EObject)t);
            if (this.contains(this.getComparison(), rightValues, t)) {
                if (!checkOrdering) continue;
                this.featureChange(match, (EStructuralFeature)reference, t, DifferenceKind.MOVE, DifferenceSource.LEFT);
                continue;
            }
            if (candidateMatch != null && candidateMatch.getRight() != null) {
                this.featureChange(match, (EStructuralFeature)reference, t, DifferenceKind.MOVE, DifferenceSource.LEFT);
                continue;
            }
            this.featureChange(match, (EStructuralFeature)reference, t, DifferenceKind.ADD, DifferenceSource.LEFT);
        }
        for (Object object : rightValues) {
            candidateMatch = this.getComparison().getMatch((EObject)object);
            if (candidateMatch == null || candidateMatch.getLeft() != null) continue;
            this.featureChange(match, (EStructuralFeature)reference, object, DifferenceKind.DELETE, DifferenceSource.LEFT);
        }
    }

    protected void computeDifferences(Match match, EAttribute attribute, boolean checkOrdering) {
        if (match.getOrigin() == null && (match.getLeft() == null || match.getRight() == null)) {
            return;
        }
        if (attribute.isMany()) {
            if (this.getComparison().isThreeWay()) {
                this.computeMultiValuedFeatureDifferencesThreeWay(match, (EStructuralFeature)attribute, checkOrdering);
            } else {
                this.computeMultiValuedFeatureDifferencesTwoWay(match, (EStructuralFeature)attribute, checkOrdering);
            }
        } else {
            this.computeSingleValuedAttributeDifferences(match, attribute);
        }
    }

    protected void computeDifferences(Match match, EReference reference, boolean checkOrdering) {
        if (reference.isContainment()) {
            if (this.getComparison().isThreeWay()) {
                this.computeContainmentDifferencesThreeWay(match, reference, checkOrdering);
            } else {
                this.computeContainmentDifferencesTwoWay(match, reference, checkOrdering);
            }
        } else if (reference.isMany()) {
            if (this.getComparison().isThreeWay()) {
                this.computeMultiValuedFeatureDifferencesThreeWay(match, (EStructuralFeature)reference, checkOrdering);
            } else {
                this.computeMultiValuedFeatureDifferencesTwoWay(match, (EStructuralFeature)reference, checkOrdering);
            }
        } else if (this.getComparison().isThreeWay()) {
            this.computeSingleValuedReferenceDifferencesThreeWay(match, reference);
        } else {
            this.computeSingleValuedReferenceDifferencesTwoWay(match, reference);
        }
    }

    protected void computeMultiValuedFeatureDifferencesThreeWay(Match match, EStructuralFeature feature, boolean checkOrdering) {
        List<Object> leftValues = DefaultDiffEngine.getAsList(match.getLeft(), feature);
        List<Object> rightValues = DefaultDiffEngine.getAsList(match.getRight(), feature);
        List<Object> originValues = DefaultDiffEngine.getAsList(match.getOrigin(), feature);
        List<Object> lcsOriginLeft = DiffUtil.longestCommonSubsequence(this.getComparison(), originValues, leftValues);
        List<Object> lcsOriginRight = DiffUtil.longestCommonSubsequence(this.getComparison(), originValues, rightValues);
        Iterable changedLeft = Iterables.filter(leftValues, (Predicate)Predicates.not(this.containedIn(this.getComparison(), lcsOriginLeft)));
        Iterable changedRight = Iterables.filter(rightValues, (Predicate)Predicates.not(this.containedIn(this.getComparison(), lcsOriginRight)));
        for (Object t : changedLeft) {
            if (this.contains(this.getComparison(), originValues, t)) {
                if (!checkOrdering) continue;
                this.featureChange(match, feature, t, DifferenceKind.MOVE, DifferenceSource.LEFT);
                continue;
            }
            this.featureChange(match, feature, t, DifferenceKind.ADD, DifferenceSource.LEFT);
        }
        for (Object t : changedRight) {
            if (this.contains(this.getComparison(), originValues, t)) {
                if (!checkOrdering) continue;
                this.featureChange(match, feature, t, DifferenceKind.MOVE, DifferenceSource.RIGHT);
                continue;
            }
            this.featureChange(match, feature, t, DifferenceKind.ADD, DifferenceSource.RIGHT);
        }
        for (Object object : originValues) {
            if (!this.contains(this.getComparison(), leftValues, object) && (feature instanceof EReference || match.getLeft() != null)) {
                this.featureChange(match, feature, object, DifferenceKind.DELETE, DifferenceSource.LEFT);
            }
            if (this.contains(this.getComparison(), rightValues, object) || !(feature instanceof EReference) && match.getRight() == null) continue;
            this.featureChange(match, feature, object, DifferenceKind.DELETE, DifferenceSource.RIGHT);
        }
    }

    protected void computeMultiValuedFeatureDifferencesTwoWay(Match match, EStructuralFeature feature, boolean checkOrdering) {
        List<Object> leftValues = DefaultDiffEngine.getAsList(match.getLeft(), feature);
        List<Object> rightValues = DefaultDiffEngine.getAsList(match.getRight(), feature);
        List<Object> lcs = DiffUtil.longestCommonSubsequence(this.getComparison(), rightValues, leftValues);
        Iterable changed = Iterables.filter(leftValues, (Predicate)Predicates.not(this.containedIn(this.getComparison(), lcs)));
        for (Object t : changed) {
            if (this.contains(this.getComparison(), rightValues, t)) {
                if (!checkOrdering) continue;
                this.featureChange(match, feature, t, DifferenceKind.MOVE, DifferenceSource.LEFT);
                continue;
            }
            this.featureChange(match, feature, t, DifferenceKind.ADD, DifferenceSource.LEFT);
        }
        for (Object object : rightValues) {
            if (this.contains(this.getComparison(), leftValues, object) || !(feature instanceof EReference) && match.getLeft() == null) continue;
            this.featureChange(match, feature, object, DifferenceKind.DELETE, DifferenceSource.LEFT);
        }
    }

    protected void computeSingleValuedAttributeDifferences(Match match, EAttribute attribute) {
        Object leftValue = UNMATCHED_VALUE;
        if (match.getLeft() != null) {
            leftValue = match.getLeft().eGet((EStructuralFeature)attribute);
        }
        Object rightValue = UNMATCHED_VALUE;
        if (match.getRight() != null) {
            rightValue = match.getRight().eGet((EStructuralFeature)attribute);
        }
        if (this.helper.matchingValues(this.getComparison(), leftValue, rightValue)) {
            if (leftValue != UNMATCHED_VALUE && match.getOrigin() != null) {
                Object originValue = match.getOrigin().eGet((EStructuralFeature)attribute);
                if (!this.helper.matchingValues(this.getComparison(), leftValue, originValue)) {
                    this.getDiffProcessor().attributeChange(match, attribute, originValue, DifferenceKind.CHANGE, DifferenceSource.LEFT);
                    this.getDiffProcessor().attributeChange(match, attribute, originValue, DifferenceKind.CHANGE, DifferenceSource.RIGHT);
                }
            }
        } else if (match.getOrigin() != null) {
            Object originValue = match.getOrigin().eGet((EStructuralFeature)attribute);
            if (this.helper.matchingValues(this.getComparison(), leftValue, originValue)) {
                Object changedValue = rightValue;
                if (this.isNullOrEmptyString(rightValue)) {
                    changedValue = originValue;
                }
                if (rightValue != UNMATCHED_VALUE) {
                    this.getDiffProcessor().attributeChange(match, attribute, changedValue, DifferenceKind.CHANGE, DifferenceSource.RIGHT);
                }
            } else if (this.helper.matchingValues(this.getComparison(), rightValue, originValue)) {
                Object changedValue = leftValue;
                if (this.isNullOrEmptyString(leftValue)) {
                    changedValue = originValue;
                }
                if (leftValue != UNMATCHED_VALUE) {
                    this.getDiffProcessor().attributeChange(match, attribute, changedValue, DifferenceKind.CHANGE, DifferenceSource.LEFT);
                }
            } else {
                Object leftChange = leftValue;
                if (this.isNullOrEmptyString(leftValue)) {
                    leftChange = originValue;
                }
                Object rightChange = rightValue;
                if (this.isNullOrEmptyString(rightValue)) {
                    rightChange = originValue;
                }
                if (leftValue != UNMATCHED_VALUE) {
                    this.getDiffProcessor().attributeChange(match, attribute, leftChange, DifferenceKind.CHANGE, DifferenceSource.LEFT);
                }
                if (rightValue != UNMATCHED_VALUE) {
                    this.getDiffProcessor().attributeChange(match, attribute, rightChange, DifferenceKind.CHANGE, DifferenceSource.RIGHT);
                }
            }
        } else {
            if (leftValue != UNMATCHED_VALUE) {
                if (this.isNullOrEmptyString(leftValue)) {
                    this.getDiffProcessor().attributeChange(match, attribute, rightValue, DifferenceKind.CHANGE, DifferenceSource.LEFT);
                } else {
                    this.getDiffProcessor().attributeChange(match, attribute, leftValue, DifferenceKind.CHANGE, DifferenceSource.LEFT);
                }
            }
            if (this.getComparison().isThreeWay() && rightValue != UNMATCHED_VALUE) {
                if (this.isNullOrEmptyString(rightValue)) {
                    this.getDiffProcessor().attributeChange(match, attribute, leftValue, DifferenceKind.CHANGE, DifferenceSource.RIGHT);
                } else {
                    this.getDiffProcessor().attributeChange(match, attribute, rightValue, DifferenceKind.CHANGE, DifferenceSource.RIGHT);
                }
            }
        }
    }

    private boolean isNullOrEmptyString(Object object) {
        return object == null || object instanceof String && ((String)object).length() == 0;
    }

    protected void computeSingleValuedReferenceDifferencesThreeWay(Match match, EReference reference) {
        Match rightValueMatch;
        boolean distinctValueRO;
        Match leftValueMatch;
        boolean distinctValueLO;
        Object leftValue = UNMATCHED_VALUE;
        if (match.getLeft() != null) {
            leftValue = match.getLeft().eGet((EStructuralFeature)reference);
        }
        Object rightValue = UNMATCHED_VALUE;
        if (match.getRight() != null) {
            rightValue = match.getRight().eGet((EStructuralFeature)reference);
        }
        Object originValue = UNMATCHED_VALUE;
        if (match.getOrigin() != null) {
            originValue = match.getOrigin().eGet((EStructuralFeature)reference);
        }
        if (distinctValueLO = (leftValueMatch = leftValue instanceof EObject ? this.getComparison().getMatch((EObject)leftValue) : null) != null ? originValue == null || leftValueMatch.getOrigin() != originValue : originValue instanceof EObject) {
            boolean originOutOfScope;
            boolean leftOutOfScope = leftValue instanceof EObject && leftValueMatch == null;
            boolean bl = originOutOfScope = originValue instanceof EObject && this.getComparison().getMatch((EObject)originValue) == null;
            if (leftValueMatch != null && !leftOutOfScope) {
                this.getDiffProcessor().referenceChange(match, reference, (EObject)leftValue, DifferenceKind.CHANGE, DifferenceSource.LEFT);
            } else if (originValue != UNMATCHED_VALUE && !originOutOfScope) {
                this.getDiffProcessor().referenceChange(match, reference, (EObject)originValue, DifferenceKind.CHANGE, DifferenceSource.LEFT);
            }
        }
        if (distinctValueRO = (rightValueMatch = rightValue instanceof EObject ? this.getComparison().getMatch((EObject)rightValue) : null) != null ? originValue == null || rightValueMatch.getOrigin() != originValue : originValue instanceof EObject) {
            boolean originOutOfScope;
            boolean rightOutOfScope = rightValue instanceof EObject && rightValueMatch == null;
            boolean bl = originOutOfScope = originValue instanceof EObject && this.getComparison().getMatch((EObject)originValue) == null;
            if (rightValueMatch != null && !rightOutOfScope) {
                this.getDiffProcessor().referenceChange(match, reference, (EObject)rightValue, DifferenceKind.CHANGE, DifferenceSource.RIGHT);
            } else if (originValue != UNMATCHED_VALUE && !originOutOfScope) {
                this.getDiffProcessor().referenceChange(match, reference, (EObject)originValue, DifferenceKind.CHANGE, DifferenceSource.RIGHT);
            }
        }
    }

    protected void computeSingleValuedReferenceDifferencesTwoWay(Match match, EReference reference) {
        Match leftValueMatch;
        boolean distinctValue;
        Object leftValue = UNMATCHED_VALUE;
        if (match.getLeft() != null) {
            leftValue = match.getLeft().eGet((EStructuralFeature)reference);
        }
        Object rightValue = UNMATCHED_VALUE;
        if (match.getRight() != null) {
            rightValue = match.getRight().eGet((EStructuralFeature)reference);
        }
        if (distinctValue = (leftValueMatch = leftValue instanceof EObject ? this.getComparison().getMatch((EObject)leftValue) : null) != null ? rightValue == null || leftValueMatch.getRight() != rightValue : rightValue instanceof EObject) {
            boolean rightOutOfScope;
            boolean leftOutOfScope = leftValue instanceof EObject && leftValueMatch == null;
            boolean bl = rightOutOfScope = rightValue instanceof EObject && this.getComparison().getMatch((EObject)rightValue) == null;
            if (leftValueMatch != null && !leftOutOfScope) {
                this.getDiffProcessor().referenceChange(match, reference, (EObject)leftValue, DifferenceKind.CHANGE, DifferenceSource.LEFT);
            } else if (rightValue != UNMATCHED_VALUE && !rightOutOfScope) {
                this.getDiffProcessor().referenceChange(match, reference, (EObject)rightValue, DifferenceKind.CHANGE, DifferenceSource.LEFT);
            }
        }
    }

    protected FeatureFilter createFeatureFilter() {
        return new FeatureFilter();
    }

    protected void featureChange(Match match, EStructuralFeature feature, Object value, DifferenceKind kind, DifferenceSource source) {
        if (feature instanceof EAttribute) {
            this.getDiffProcessor().attributeChange(match, (EAttribute)feature, value, kind, source);
        } else if (value instanceof EObject) {
            this.getDiffProcessor().referenceChange(match, (EReference)feature, (EObject)value, kind, source);
        }
    }

    protected Comparison getComparison() {
        return this.currentComparison;
    }

    protected final IDiffProcessor getDiffProcessor() {
        return this.diffProcessor;
    }
}

