/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.equi;

import java.util.Set;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.ComparePackage;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Equivalence;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.equi.IEquiEngine;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DefaultEquiEngine
implements IEquiEngine {
    private EcoreUtil.CrossReferencer crossReferencerModelObjectsToDiffs;

    public DefaultEquiEngine() {
    }

    public DefaultEquiEngine(EcoreUtil.CrossReferencer crossReferencer) {
        this.crossReferencerModelObjectsToDiffs = crossReferencer;
    }

    public void computeEquivalences(Comparison comparison) {
        if (this.crossReferencerModelObjectsToDiffs == null) {
            this.crossReferencerModelObjectsToDiffs = ReferenceUtil.initializeCrossReferencer(comparison);
        }
        for (Diff difference : comparison.getDifferences()) {
            this.checkForEquivalences(comparison, difference);
        }
    }

    protected void checkForEquivalences(Comparison comparison, Diff difference) {
        ReferenceChange diff;
        Equivalence equivalence;
        if (difference instanceof ReferenceChange && ((ReferenceChange)difference).getReference().getEOpposite() != null && (equivalence = (diff = (ReferenceChange)difference).getEquivalence()) == null) {
            equivalence = CompareFactory.eINSTANCE.createEquivalence();
            comparison.getEquivalences().add((Object)equivalence);
            equivalence.getDifferences().add((Object)diff);
            Set<ReferenceChange> equivalentDifferences = ReferenceUtil.getCrossReferences(this.crossReferencerModelObjectsToDiffs, MatchUtil.getContainer(comparison, diff), (EStructuralFeature)ComparePackage.eINSTANCE.getReferenceChange_Value(), ReferenceChange.class);
            for (ReferenceChange referenceChange : equivalentDifferences) {
                if (referenceChange.getReference().getEOpposite() == null || !referenceChange.getReference().getEOpposite().equals(diff.getReference()) || !diff.getValue().equals(MatchUtil.getContainer(comparison, referenceChange))) continue;
                equivalence.getDifferences().add((Object)referenceChange);
                break;
            }
            this.addChangesFromOrigin(comparison, diff, equivalence);
        }
    }

    private void addChangesFromOrigin(Comparison comparison, ReferenceChange diff, Equivalence equivalence) {
        if (!diff.getReference().isMany()) {
            EObject originContainer = MatchUtil.getOriginContainer(comparison, diff);
            Set<ReferenceChange> equivalentDifferences2 = ReferenceUtil.getCrossReferences(this.crossReferencerModelObjectsToDiffs, originContainer, (EStructuralFeature)ComparePackage.eINSTANCE.getReferenceChange_Value(), ReferenceChange.class);
            for (ReferenceChange referenceChange : equivalentDifferences2) {
                if (!MatchUtil.getContainer(comparison, referenceChange).equals(originContainer.eGet((EStructuralFeature)diff.getReference()))) continue;
                equivalence.getDifferences().add((Object)referenceChange);
            }
        }
    }
}

