/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.spec;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.AbstractEList;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.EMFCompareConfiguration;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.impl.ComparisonImpl;
import org.eclipse.emf.compare.internal.MatchCrossReferencer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparisonSpec
extends ComparisonImpl {
    private boolean isThreeWay;
    private int resourceCount = -1;

    @Override
    public EList<Diff> getDifferences() {
        UnmodifiableIterator diffIterator = Iterators.filter((Iterator)this.eAllContents(), Diff.class);
        BasicEList allDifferences = new BasicEList();
        while (diffIterator.hasNext()) {
            ((AbstractEList)allDifferences).addUnique((Object)((Diff)diffIterator.next()));
        }
        return allDifferences;
    }

    @Override
    public EList<Diff> getDifferences(EObject element) {
        Match match = this.getMatch(element);
        if (match != null) {
            return match.getDifferences();
        }
        return new BasicEList();
    }

    @Override
    public Match getMatch(EObject element) {
        Preconditions.checkNotNull((Object)element);
        MatchCrossReferencer adapter = null;
        Iterator adapterIterator = this.eAdapters().iterator();
        while (adapterIterator.hasNext() && adapter == null) {
            Adapter candidate = (Adapter)adapterIterator.next();
            if (!(candidate instanceof MatchCrossReferencer)) continue;
            adapter = (MatchCrossReferencer)candidate;
        }
        if (adapter == null) {
            adapter = new MatchCrossReferencer();
            this.eAdapters().add((Object)adapter);
        }
        Collection settings = adapter.getInverseReferences(element, false);
        Iterator matchIter = Iterables.filter((Iterable)Iterables.transform((Iterable)settings, (Function)new MatchInverseReference()), (Predicate)Predicates.notNull()).iterator();
        Match result = null;
        if (matchIter.hasNext()) {
            result = (Match)matchIter.next();
        }
        return result;
    }

    @Override
    public EMFCompareConfiguration getConfiguration() {
        EMFCompareConfiguration ret = null;
        for (Adapter eAdapter : this.eAdapters()) {
            if (!eAdapter.isAdapterForType(EMFCompareConfiguration.class)) continue;
            ret = (EMFCompareConfiguration)eAdapter;
            break;
        }
        if (ret == null) {
            ret = EMFCompareConfiguration.builder().build();
        }
        return ret;
    }

    @Override
    public boolean isThreeWay() {
        if (this.isThreeWay) {
            return this.isThreeWay;
        }
        EList<MatchResource> resources = this.getMatchedResources();
        int count = resources.size();
        if (this.resourceCount != count) {
            this.isThreeWay = false;
            this.resourceCount = count;
            int i = 0;
            while (i < count) {
                MatchResource matchResource = (MatchResource)resources.get(i);
                if (matchResource.getOriginURI() != null && matchResource.getOriginURI().length() > 0) {
                    this.isThreeWay = true;
                }
                ++i;
            }
        }
        return this.isThreeWay;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MatchInverseReference
    implements Function<EStructuralFeature.Setting, Match> {
        private MatchInverseReference() {
        }

        public Match apply(EStructuralFeature.Setting input) {
            if (input != null && input.getEObject() instanceof Match) {
                return (Match)input.getEObject();
            }
            return null;
        }
    }
}

