/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.spec;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.impl.MatchImpl;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchSpec
extends MatchImpl {
    private static final Function<Match, Iterable<Match>> ALL_SUBMATCHES = new Function<Match, Iterable<Match>>(){

        public Iterable<Match> apply(Match match) {
            if (match == null) {
                return Lists.newArrayList();
            }
            Iterable allSubmatches = Iterables.concat((Iterable)Iterables.transform(match.getSubmatches(), (Function)ALL_SUBMATCHES));
            return Iterables.concat(match.getSubmatches(), (Iterable)allSubmatches);
        }
    };
    private static final Function<Match, List<Diff>> DIFFERENCES = new Function<Match, List<Diff>>(){

        public List<Diff> apply(Match match) {
            if (match == null) {
                return Lists.newArrayList();
            }
            return match.getDifferences();
        }
    };

    @Override
    public Comparison getComparison() {
        Comparison ret = null;
        EObject eContainer = this.eContainer();
        while (!(eContainer instanceof Comparison) && eContainer != null) {
            eContainer = eContainer.eContainer();
        }
        if (eContainer != null) {
            ret = (Comparison)eContainer;
        }
        return ret;
    }

    @Override
    public Iterable<Match> getAllSubmatches() {
        return (Iterable)ALL_SUBMATCHES.apply((Object)this);
    }

    @Override
    public Iterable<Diff> getAllDifferences() {
        Iterable allSubDifferences = Iterables.concat((Iterable)Iterables.transform(this.getAllSubmatches(), DIFFERENCES));
        return Iterables.concat(this.getDifferences(), (Iterable)allSubDifferences);
    }
}

