/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.spec;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.impl.ReferenceChangeImpl;
import org.eclipse.emf.compare.utils.DiffUtil;
import org.eclipse.emf.compare.utils.EMFCompareCopier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMIResource;

public class ReferenceChangeSpec
extends ReferenceChangeImpl {
    public void copyLeftToRight() {
        Match valueMatch;
        if (this.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        if (this.getSource() == DifferenceSource.LEFT) {
            this.mergeRequires(false);
            switch (this.getKind()) {
                case ADD: {
                    this.addInTarget(false);
                    break;
                }
                case DELETE: {
                    this.removeFromTarget(false);
                    break;
                }
                case MOVE: {
                    this.moveElement(false);
                    break;
                }
                case CHANGE: {
                    valueMatch = this.getMatch().getComparison().getMatch(this.getValue());
                    if (valueMatch != null && this.getValue() != valueMatch.getLeft()) {
                        this.removeFromTarget(false);
                        break;
                    }
                    this.addInTarget(false);
                    break;
                }
            }
        } else {
            this.mergeRequiredBy(false);
            switch (this.getKind()) {
                case ADD: {
                    this.removeFromTarget(false);
                    break;
                }
                case DELETE: {
                    this.addInTarget(false);
                    break;
                }
                case MOVE: {
                    this.moveElement(false);
                    break;
                }
                case CHANGE: {
                    valueMatch = this.getMatch().getComparison().getMatch(this.getValue());
                    if (valueMatch != null && this.getValue() != valueMatch.getRight()) {
                        this.addInTarget(false);
                        break;
                    }
                    this.resetInTarget(false);
                    break;
                }
            }
        }
        this.setState(DifferenceState.MERGED);
        if (this.getEquivalence() != null) {
            for (Diff equivalent : this.getEquivalence().getDifferences()) {
                equivalent.setState(DifferenceState.MERGED);
            }
        }
    }

    public void copyRightToLeft() {
        Match valueMatch;
        if (this.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        if (this.getSource() == DifferenceSource.LEFT) {
            this.mergeRequiredBy(true);
            switch (this.getKind()) {
                case ADD: {
                    this.removeFromTarget(true);
                    break;
                }
                case DELETE: {
                    this.addInTarget(true);
                    break;
                }
                case MOVE: {
                    this.moveElement(true);
                    break;
                }
                case CHANGE: {
                    valueMatch = this.getMatch().getComparison().getMatch(this.getValue());
                    if (valueMatch != null && this.getValue() != valueMatch.getLeft()) {
                        this.addInTarget(true);
                        break;
                    }
                    this.resetInTarget(true);
                    break;
                }
            }
        } else {
            this.mergeRequires(true);
            switch (this.getKind()) {
                case ADD: {
                    this.addInTarget(true);
                    break;
                }
                case DELETE: {
                    this.removeFromTarget(true);
                    break;
                }
                case MOVE: {
                    this.moveElement(true);
                    break;
                }
                case CHANGE: {
                    valueMatch = this.getMatch().getComparison().getMatch(this.getValue());
                    if (valueMatch != null && this.getValue() != valueMatch.getRight()) {
                        this.removeFromTarget(true);
                        break;
                    }
                    this.addInTarget(true);
                    break;
                }
            }
        }
        this.setState(DifferenceState.MERGED);
        if (this.getEquivalence() != null) {
            for (Diff equivalent : this.getEquivalence().getDifferences()) {
                equivalent.setState(DifferenceState.MERGED);
            }
        }
    }

    public void discard() {
        this.setState(DifferenceState.DISCARDED);
    }

    protected void mergeRequiredBy(boolean rightToLeft) {
        for (Diff dependency : this.getRequiredBy()) {
            if (dependency.getState() == DifferenceState.MERGED) continue;
            if (rightToLeft) {
                dependency.copyRightToLeft();
                continue;
            }
            dependency.copyLeftToRight();
        }
    }

    protected void mergeRequires(boolean rightToLeft) {
        for (Diff dependency : this.getRequires()) {
            if (dependency.getState() == DifferenceState.MERGED) continue;
            if (rightToLeft) {
                dependency.copyRightToLeft();
                continue;
            }
            dependency.copyLeftToRight();
        }
    }

    protected void moveElement(boolean rightToLeft) {
        EObject expectedContainer = rightToLeft ? this.getMatch().getLeft() : this.getMatch().getRight();
        Comparison comparison = this.getMatch().getComparison();
        Match valueMatch = comparison.getMatch(this.getValue());
        if (!(expectedContainer == null || valueMatch == null || rightToLeft && valueMatch.getLeft() == null || !rightToLeft && valueMatch.getRight() == null)) {
            EObject expectedValue = rightToLeft ? valueMatch.getLeft() : valueMatch.getRight();
            this.doMove(comparison, expectedContainer, expectedValue, rightToLeft);
        }
    }

    protected void doMove(Comparison comparison, EObject expectedContainer, EObject expectedValue, boolean rightToLeft) {
        if (this.getReference().isMany()) {
            List targetList;
            int insertionIndex = DiffUtil.findInsertionIndex(comparison, this, rightToLeft);
            if (insertionIndex > (targetList = (List)expectedContainer.eGet((EStructuralFeature)this.getReference())).indexOf(expectedValue)) {
                --insertionIndex;
            }
            if (targetList instanceof EList) {
                ((EList)targetList).move(insertionIndex, (Object)expectedValue);
            } else {
                targetList.remove(expectedValue);
                targetList.add(insertionIndex, expectedValue);
            }
        } else {
            expectedContainer.eSet((EStructuralFeature)this.getReference(), (Object)expectedValue);
        }
    }

    protected void addInTarget(boolean rightToLeft) {
        EObject expectedContainer = rightToLeft ? this.getMatch().getLeft() : this.getMatch().getRight();
        Comparison comparison = this.getMatch().getComparison();
        Match valueMatch = comparison.getMatch(this.getValue());
        if (expectedContainer != null && valueMatch != null) {
            EObject expectedValue;
            if (rightToLeft) {
                if (this.getReference().isContainment()) {
                    expectedValue = this.createTarget(this.getValue());
                    valueMatch.setLeft(expectedValue);
                } else {
                    expectedValue = valueMatch.getLeft();
                }
            } else if (this.getReference().isContainment()) {
                expectedValue = this.createTarget(this.getValue());
                valueMatch.setRight(expectedValue);
            } else {
                expectedValue = valueMatch.getRight();
            }
            if (this.getReference().isMany()) {
                int insertionIndex = DiffUtil.findInsertionIndex(comparison, this, rightToLeft);
                List targetList = (List)expectedContainer.eGet((EStructuralFeature)this.getReference());
                if (targetList instanceof InternalEList) {
                    ((InternalEList)targetList).addUnique(insertionIndex, (Object)expectedValue);
                } else {
                    targetList.add(insertionIndex, expectedValue);
                }
            } else {
                expectedContainer.eSet((EStructuralFeature)this.getReference(), (Object)expectedValue);
            }
            if (this.getReference().isContainment()) {
                Resource initialResource = this.getValue().eResource();
                Resource targetResource = expectedValue.eResource();
                if (initialResource instanceof XMIResource && targetResource instanceof XMIResource) {
                    ((XMIResource)targetResource).setID(expectedValue, ((XMIResource)initialResource).getID(this.getValue()));
                }
            }
        }
    }

    protected EObject createTarget(EObject referenceObject) {
        EMFCompareCopier copier = new EMFCompareCopier();
        return copier.copy(referenceObject);
    }

    protected void removeFromTarget(boolean rightToLeft) {
        EObject currentContainer = rightToLeft ? this.getMatch().getLeft() : this.getMatch().getRight();
        Comparison comparison = this.getMatch().getComparison();
        Match valueMatch = comparison.getMatch(this.getValue());
        if (currentContainer != null && valueMatch != null) {
            EObject expectedValue = rightToLeft ? valueMatch.getLeft() : valueMatch.getRight();
            if (this.getReference().isContainment() && expectedValue != null) {
                EcoreUtil.remove((EObject)expectedValue);
                if (rightToLeft) {
                    valueMatch.setLeft(null);
                } else {
                    valueMatch.setRight(null);
                }
            } else if (this.getReference().isMany()) {
                List targetList = (List)currentContainer.eGet((EStructuralFeature)this.getReference());
                targetList.remove(expectedValue);
            } else {
                currentContainer.eUnset((EStructuralFeature)this.getReference());
            }
        }
    }

    protected void resetInTarget(boolean rightToLeft) {
        EObject targetContainer = rightToLeft ? this.getMatch().getLeft() : this.getMatch().getRight();
        EObject originContainer = this.getMatch().getComparison().isThreeWay() ? this.getMatch().getOrigin() : (rightToLeft ? this.getMatch().getRight() : this.getMatch().getLeft());
        if (originContainer == null || !targetContainer.eIsSet((EStructuralFeature)this.getReference()) || !originContainer.eIsSet((EStructuralFeature)this.getReference())) {
            targetContainer.eUnset((EStructuralFeature)this.getReference());
        } else {
            Match valueMatch = this.getMatch().getComparison().getMatch((EObject)originContainer.eGet((EStructuralFeature)this.getReference()));
            EObject expectedValue = valueMatch == null ? null : (rightToLeft ? valueMatch.getLeft() : valueMatch.getRight());
            targetContainer.eSet((EStructuralFeature)this.getReference(), (Object)expectedValue);
        }
    }
}

