/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompareConfiguration;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.match.eobject.IEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.IdentifierEObjectMatcher;
import org.eclipse.emf.compare.match.resource.IResourceMatcher;
import org.eclipse.emf.compare.match.resource.StrategyResourceMatcher;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class DefaultMatchEngine
implements IMatchEngine {
    private Comparison comparison;
    private IComparisonScope comparisonScope;

    public Comparison match(IComparisonScope scope, EMFCompareConfiguration configuration) {
        this.comparisonScope = scope;
        DefaultMatchEngine.associate(this.getComparison(), configuration);
        Notifier left = this.getScope().getLeft();
        Notifier right = this.getScope().getRight();
        Notifier origin = this.getScope().getOrigin();
        if (left instanceof ResourceSet || right instanceof ResourceSet) {
            this.match((ResourceSet)left, (ResourceSet)right, (ResourceSet)origin);
        } else if (left instanceof Resource || right instanceof Resource) {
            MatchResource match = CompareFactory.eINSTANCE.createMatchResource();
            match.setLeft((Resource)left);
            match.setRight((Resource)right);
            match.setOrigin((Resource)origin);
            if (left != null && ((Resource)left).getURI() != null) {
                match.setLeftURI(((Resource)left).getURI().toString());
            }
            if (right != null && ((Resource)right).getURI() != null) {
                match.setRightURI(((Resource)right).getURI().toString());
            }
            if (origin != null && ((Resource)origin).getURI() != null) {
                match.setOriginURI(((Resource)origin).getURI().toString());
            }
            this.getComparison().getMatchedResources().add((Object)match);
            this.match((Resource)left, (Resource)right, (Resource)origin);
        } else if (left instanceof EObject || right instanceof EObject) {
            this.match((EObject)left, (EObject)right, (EObject)origin);
        }
        return this.getComparison();
    }

    protected void match(ResourceSet left, ResourceSet right, ResourceSet origin) {
        Iterator<? extends Resource> leftChildren = this.getScope().getCoveredResources(left);
        Iterator<? extends Resource> rightChildren = this.getScope().getCoveredResources(right);
        Object originChildren = origin != null ? this.getScope().getCoveredResources(origin) : Iterators.emptyIterator();
        IResourceMatcher matcher = this.getResourceMatcher();
        Iterable<MatchResource> mappings = matcher.createMappings(leftChildren, rightChildren, (Iterator<? extends Resource>)originChildren);
        for (MatchResource mapping : mappings) {
            this.getComparison().getMatchedResources().add((Object)mapping);
            this.match(mapping.getLeft(), mapping.getRight(), mapping.getOrigin());
        }
    }

    protected void match(Resource left, Resource right, Resource origin) {
        if (DefaultMatchEngine.atLeastTwo(left == null, right == null, origin == null)) {
            return;
        }
        Object leftEObjects = left != null ? this.getScope().getCoveredEObjects(left) : Iterators.emptyIterator();
        Object rightEObjects = right != null ? this.getScope().getCoveredEObjects(right) : Iterators.emptyIterator();
        Object originEObjects = origin != null ? this.getScope().getCoveredEObjects(origin) : Iterators.emptyIterator();
        IEObjectMatcher matcher = this.createEObjectMatcher();
        Iterable<Match> matches = matcher.createMatches((Iterator<? extends EObject>)leftEObjects, (Iterator<? extends EObject>)rightEObjects, (Iterator<? extends EObject>)originEObjects);
        Iterables.addAll(this.getComparison().getMatches(), matches);
    }

    protected void match(EObject left, EObject right, EObject origin) {
        if (left == null || right == null) {
            throw new IllegalArgumentException();
        }
        Iterator leftEObjects = Iterators.concat((Iterator)Iterators.singletonIterator((Object)left), this.getScope().getChildren(left));
        Iterator rightEObjects = Iterators.concat((Iterator)Iterators.singletonIterator((Object)right), this.getScope().getChildren(right));
        Object originEObjects = origin != null ? Iterators.concat((Iterator)Iterators.singletonIterator((Object)origin), this.getScope().getChildren(origin)) : Iterators.emptyIterator();
        IEObjectMatcher matcher = this.createEObjectMatcher();
        Iterable<Match> matches = matcher.createMatches(leftEObjects, rightEObjects, (Iterator<? extends EObject>)originEObjects);
        Iterables.addAll(this.getComparison().getMatches(), matches);
    }

    protected IResourceMatcher getResourceMatcher() {
        return new StrategyResourceMatcher();
    }

    protected IEObjectMatcher createEObjectMatcher() {
        return new IdentifierEObjectMatcher();
    }

    protected Comparison getComparison() {
        if (this.comparison == null) {
            this.comparison = CompareFactory.eINSTANCE.createComparison();
        }
        return this.comparison;
    }

    protected IComparisonScope getScope() {
        return this.comparisonScope;
    }

    protected static boolean atLeastTwo(boolean condition1, boolean condition2, boolean condition3) {
        return condition1 && (condition2 || condition3) || condition2 && condition3;
    }

    private static void associate(Comparison comparison, EMFCompareConfiguration configuration) {
        Iterator eAdapters = comparison.eAdapters().iterator();
        while (eAdapters.hasNext()) {
            Adapter eAdapter = (Adapter)eAdapters.next();
            if (!eAdapter.isAdapterForType(EMFCompareConfiguration.class)) continue;
            eAdapters.remove();
            if (!(eAdapter instanceof Adapter.Internal)) continue;
            ((Adapter.Internal)eAdapter).unsetTarget((Notifier)comparison);
        }
        comparison.eAdapters().add((Object)configuration);
        configuration.setTarget((Notifier)comparison);
    }
}

