/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.eobject;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.match.eobject.IEObjectMatcher;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentifierEObjectMatcher
implements IEObjectMatcher {
    @Override
    public Iterable<Match> createMatches(Iterator<? extends EObject> leftEObjects, Iterator<? extends EObject> rightEObjects, Iterator<? extends EObject> originEObjects) {
        Match parent;
        EObject parentEObject;
        Match match;
        String identifier;
        LinkedHashSet matches = Sets.newLinkedHashSet();
        HashMap idToMatch = Maps.newHashMap();
        HashMap leftEObjectsToMatch = Maps.newHashMap();
        HashMap rightEObjectsToMatch = Maps.newHashMap();
        HashMap originEObjectsToMatch = Maps.newHashMap();
        while (leftEObjects.hasNext()) {
            EObject left = leftEObjects.next();
            Match match2 = CompareFactory.eINSTANCE.createMatch();
            match2.setLeft(left);
            EObject parentEObject2 = left.eContainer();
            Match parent2 = (Match)leftEObjectsToMatch.get(parentEObject2);
            if (parent2 != null) {
                parent2.getSubmatches().add((Object)match2);
            } else {
                matches.add(match2);
            }
            String identifier2 = this.getID(left);
            if (identifier2 != null) {
                idToMatch.put(identifier2, match2);
            }
            leftEObjectsToMatch.put(left, match2);
        }
        while (rightEObjects.hasNext()) {
            EObject right = rightEObjects.next();
            identifier = this.getID(right);
            match = (Match)idToMatch.get(identifier);
            if (match != null) {
                match.setRight(right);
                rightEObjectsToMatch.put(right, match);
                continue;
            }
            match = CompareFactory.eINSTANCE.createMatch();
            match.setRight(right);
            parentEObject = right.eContainer();
            parent = (Match)rightEObjectsToMatch.get(parentEObject);
            if (parent != null) {
                parent.getSubmatches().add((Object)match);
            } else {
                matches.add(match);
            }
            if (identifier != null) {
                idToMatch.put(identifier, match);
            }
            rightEObjectsToMatch.put(right, match);
        }
        while (originEObjects.hasNext()) {
            EObject origin = originEObjects.next();
            identifier = this.getID(origin);
            match = (Match)idToMatch.get(identifier);
            if (match != null) {
                match.setOrigin(origin);
                originEObjectsToMatch.put(origin, match);
                continue;
            }
            match = CompareFactory.eINSTANCE.createMatch();
            match.setOrigin(origin);
            parentEObject = origin.eContainer();
            parent = (Match)originEObjectsToMatch.get(parentEObject);
            if (parent != null) {
                parent.getSubmatches().add((Object)match);
            } else {
                matches.add(match);
            }
            if (identifier != null) {
                idToMatch.put(identifier, match);
            }
            originEObjectsToMatch.put(origin, match);
        }
        return matches;
    }

    protected String getID(EObject eObject) {
        Resource eObjectResource;
        if (eObject.eIsProxy()) {
            return ((InternalEObject)eObject).eProxyURI().fragment();
        }
        String identifier = EcoreUtil.getID((EObject)eObject);
        if (identifier == null && (eObjectResource = eObject.eResource()) instanceof XMIResource) {
            identifier = ((XMIResource)eObjectResource).getID(eObject);
        }
        return identifier;
    }
}

