/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.req;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.ComparePackage;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.req.IReqEngine;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultReqEngine
implements IReqEngine {
    private EcoreUtil.CrossReferencer crossReferencerModelObjectsToDiffs;

    public DefaultReqEngine() {
    }

    public DefaultReqEngine(EcoreUtil.CrossReferencer crossReferencerModelObjectsToDiffs) {
        this.crossReferencerModelObjectsToDiffs = crossReferencerModelObjectsToDiffs;
    }

    @Override
    public void computeRequirements(Comparison comparison) {
        if (this.crossReferencerModelObjectsToDiffs == null) {
            this.crossReferencerModelObjectsToDiffs = ReferenceUtil.initializeCrossReferencer(comparison);
        }
        for (Diff difference : comparison.getDifferences()) {
            this.checkForRequiredDifferences(comparison, difference);
        }
    }

    protected void checkForRequiredDifferences(Comparison comparison, Diff difference) {
        if (difference instanceof ReferenceChange) {
            ReferenceChange sourceDifference = (ReferenceChange)difference;
            HashSet<ReferenceChange> requiredDifferences = new HashSet<ReferenceChange>();
            HashSet<ReferenceChange> requiredByDifferences = new HashSet<ReferenceChange>();
            if (sourceDifference.getKind().equals((Object)DifferenceKind.ADD) && sourceDifference.getReference().isContainment()) {
                requiredDifferences.addAll(this.getDifferenceOnGivenObject(sourceDifference.getValue().eContainer(), DifferenceKind.ADD));
                requiredDifferences.addAll(this.getDELOriginValueOnContainmentRefSingle(comparison, sourceDifference));
            } else if ((sourceDifference.getKind().equals((Object)DifferenceKind.ADD) || DefaultReqEngine.isChangeAdd(comparison, sourceDifference)) && !sourceDifference.getReference().isContainment()) {
                requiredDifferences.addAll(this.getDifferenceOnGivenObject(sourceDifference.getValue(), DifferenceKind.ADD));
                requiredDifferences.addAll(this.getDifferenceOnGivenObject(MatchUtil.getContainer(comparison, sourceDifference), DifferenceKind.ADD));
            } else if (sourceDifference.getKind().equals((Object)DifferenceKind.DELETE) && sourceDifference.getReference().isContainment()) {
                requiredDifferences.addAll(this.getDELOutgoingReferences(comparison, sourceDifference));
                requiredDifferences.addAll(this.getDifferenceOnGivenObject((List<EObject>)sourceDifference.getValue().eContents(), DifferenceKind.DELETE));
                requiredDifferences.addAll(this.getMOVEContainedObjects(comparison, sourceDifference));
            } else if ((sourceDifference.getKind().equals((Object)DifferenceKind.DELETE) || DefaultReqEngine.isChangeDelete(comparison, sourceDifference)) && !sourceDifference.getReference().isContainment()) {
                requiredByDifferences.addAll(this.getDifferenceOnGivenObject(sourceDifference.getValue(), DifferenceKind.DELETE));
            } else if (sourceDifference.getKind().equals((Object)DifferenceKind.MOVE) && sourceDifference.getReference().isContainment()) {
                EObject container = sourceDifference.getValue().eContainer();
                requiredDifferences.addAll(this.getDifferenceOnGivenObject(container, DifferenceKind.ADD));
                requiredDifferences.addAll(this.getDifferenceOnGivenObject(container, DifferenceKind.MOVE));
            } else if (sourceDifference.getKind().equals((Object)DifferenceKind.CHANGE) && !DefaultReqEngine.isChangeAdd(comparison, sourceDifference) && !DefaultReqEngine.isChangeDelete(comparison, sourceDifference)) {
                requiredByDifferences.addAll(this.getDifferenceOnGivenObject(MatchUtil.getOriginValue(comparison, sourceDifference), DifferenceKind.DELETE));
                requiredDifferences.addAll(this.getDifferenceOnGivenObject(sourceDifference.getValue(), DifferenceKind.ADD));
            }
            sourceDifference.getRequires().addAll(requiredDifferences);
            sourceDifference.getRequiredBy().addAll(requiredByDifferences);
        }
    }

    private Set<ReferenceChange> getDELOriginValueOnContainmentRefSingle(Comparison comparison, ReferenceChange sourceDifference) {
        EObject originContainer;
        Object originValue;
        Set<ReferenceChange> result = new HashSet<ReferenceChange>();
        if (!sourceDifference.getReference().isMany() && (originValue = (originContainer = MatchUtil.getOriginContainer(comparison, sourceDifference)).eGet((EStructuralFeature)sourceDifference.getReference())) instanceof EObject) {
            result = this.getDifferenceOnGivenObject((EObject)originValue, DifferenceKind.DELETE);
        }
        return result;
    }

    private Set<ReferenceChange> getDifferenceOnGivenObject(EObject object, DifferenceKind kind) {
        return ReferenceUtil.getReferenceChanges(this.crossReferencerModelObjectsToDiffs, object, (EStructuralFeature)ComparePackage.eINSTANCE.getReferenceChange_Value(), kind, Boolean.TRUE);
    }

    private Set<ReferenceChange> getDifferenceOnGivenObject(List<EObject> objects, DifferenceKind kind) {
        HashSet<ReferenceChange> result = new HashSet<ReferenceChange>();
        for (EObject object : objects) {
            result.addAll(this.getDifferenceOnGivenObject(object, kind));
        }
        return result;
    }

    private Set<ReferenceChange> getDELOutgoingReferences(Comparison comparison, ReferenceChange sourceDifference) {
        HashSet<ReferenceChange> result = new HashSet<ReferenceChange>();
        EObject value = sourceDifference.getValue();
        EList outgoingReferences = value.eCrossReferences();
        block0: for (EObject outgoingRef : outgoingReferences) {
            Set<ReferenceChange> requiredDifferences = ReferenceUtil.getCrossReferences(this.crossReferencerModelObjectsToDiffs, outgoingRef, (EStructuralFeature)ComparePackage.eINSTANCE.getReferenceChange_Value(), ReferenceChange.class);
            for (ReferenceChange diff : requiredDifferences) {
                if (diff.getReference().isContainment() || !diff.getKind().equals((Object)DifferenceKind.DELETE) && !DefaultReqEngine.isChangeDelete(comparison, diff) || !value.eClass().getEAllReferences().contains((Object)diff.getReference())) continue;
                result.add(diff);
                continue block0;
            }
        }
        return result;
    }

    private Set<ReferenceChange> getMOVEContainedObjects(Comparison comparison, ReferenceChange sourceDifference) {
        HashSet<ReferenceChange> result = new HashSet<ReferenceChange>();
        EObject value = sourceDifference.getValue();
        EList contents = value.eContents();
        for (EObject content : contents) {
            EObject originObject = MatchUtil.getOriginObject(comparison, content);
            if (originObject == null) continue;
            result.addAll(ReferenceUtil.getReferenceChanges(this.crossReferencerModelObjectsToDiffs, originObject, (EStructuralFeature)ComparePackage.eINSTANCE.getReferenceChange_Value(), DifferenceKind.MOVE, Boolean.TRUE));
        }
        return result;
    }

    private static boolean isChangeAdd(Comparison comparison, ReferenceChange difference) {
        if (!difference.getReference().isMany() && !difference.getReference().isContainment()) {
            boolean isAddRight;
            EObject value = difference.getValue();
            Match valueMatch = comparison.getMatch(value);
            boolean isAddLeft = valueMatch.getLeft() == value && difference.getSource().equals((Object)DifferenceSource.LEFT);
            boolean bl = isAddRight = valueMatch.getRight() == value && difference.getSource().equals((Object)DifferenceSource.RIGHT);
            return MatchUtil.getOriginValue(comparison, difference) == null && (isAddLeft || isAddRight);
        }
        return false;
    }

    private static boolean isChangeDelete(Comparison comparison, ReferenceChange difference) {
        boolean result = false;
        if (!difference.getReference().isMany() && !difference.getReference().isContainment()) {
            EObject value = difference.getValue();
            Match valueMatch = comparison.getMatch(value);
            if (comparison.isThreeWay()) {
                return valueMatch.getOrigin() == value;
            }
            result = valueMatch.getRight() == value && difference.getSource().equals((Object)DifferenceSource.LEFT);
        }
        return result;
    }
}

