/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.utils;

import java.lang.reflect.Array;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class EqualityHelper {
    public boolean matchingValues(Comparison comparison, Object object1, Object object2) {
        boolean equal;
        if (object1 == object2) {
            equal = true;
        } else if (object1 instanceof EEnumLiteral && object2 instanceof EEnumLiteral) {
            EEnumLiteral literal1 = (EEnumLiteral)object1;
            EEnumLiteral literal2 = (EEnumLiteral)object2;
            String value1 = String.valueOf(literal1.getLiteral()) + literal1.getValue();
            String value2 = String.valueOf(literal2.getLiteral()) + literal2.getValue();
            equal = value1.equals(value2);
        } else {
            equal = object1 instanceof EObject && object2 instanceof EObject ? EqualityHelper.matchingEObjects(comparison, (EObject)object1, (EObject)object2) : (object1 != null && object1.getClass().isArray() && object2 != null && object2.getClass().isArray() ? this.matchingArrays(comparison, object1, object2) : (this.isEmptyString(object1) || this.isEmptyString(object2) ? object1 == null || object2 == null : object1 != null && object1.equals(object2)));
        }
        return equal;
    }

    private boolean isEmptyString(Object object) {
        return object instanceof String && ((String)object).length() == 0;
    }

    private boolean matchingArrays(Comparison comparison, Object object1, Object object2) {
        boolean equal = true;
        int length1 = Array.getLength(object1);
        if (length1 != Array.getLength(object2)) {
            equal = true;
        } else {
            int i = 0;
            while (i < length1 && equal) {
                Object element1 = Array.get(object1, i);
                Object element2 = Array.get(object2, i);
                equal = this.matchingValues(comparison, element1, element2);
                ++i;
            }
        }
        return equal;
    }

    private static boolean matchingEObjects(Comparison comparison, EObject object1, EObject object2) {
        boolean equal;
        Match match = comparison.getMatch(object1);
        if (match != null) {
            equal = match.getLeft() == object2 || match.getRight() == object2 || match.getOrigin() == object2;
        } else {
            URI uri1 = EcoreUtil.getURI((EObject)object1);
            URI uri2 = EcoreUtil.getURI((EObject)object2);
            equal = uri1.hasFragment() && uri2.hasFragment() ? uri1.fragment().equals(uri2.fragment()) : uri1.equals((Object)uri2);
        }
        return equal;
    }

    public boolean matchingValues(Object object1, Object object2) {
        boolean equal;
        if (object1 == object2) {
            equal = true;
        } else if (object1 instanceof EEnumLiteral && object2 instanceof EEnumLiteral) {
            EEnumLiteral literal1 = (EEnumLiteral)object1;
            EEnumLiteral literal2 = (EEnumLiteral)object2;
            String value1 = String.valueOf(literal1.getLiteral()) + literal1.getValue();
            String value2 = String.valueOf(literal2.getLiteral()) + literal2.getValue();
            equal = value1.equals(value2);
        } else {
            equal = object1 != null && object1.getClass().isArray() && object2 != null && object2.getClass().isArray() ? this.matchingArrays(object1, object2) : (this.isEmptyString(object1) || this.isEmptyString(object2) ? object1 == null || object2 == null : object1 != null && object1.equals(object2));
        }
        return equal;
    }

    private boolean matchingArrays(Object object1, Object object2) {
        boolean equal = true;
        int length1 = Array.getLength(object1);
        if (length1 != Array.getLength(object2)) {
            equal = true;
        } else {
            int i = 0;
            while (i < length1 && equal) {
                Object element1 = Array.get(object1, i);
                Object element2 = Array.get(object2, i);
                equal = this.matchingValues(element1, element2);
                ++i;
            }
        }
        return equal;
    }
}

