/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer;

import java.util.EventObject;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.compare.internal.CompareHandlerService;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.DynamicObject;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.EMFCompareColor;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.RedoAction;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.UndoAction;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.ComparisonNode;
import org.eclipse.emf.compare.ide.ui.internal.util.EMFCompareEditingDomain;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.ICompareColor;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.ICompareColorProvider;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.MergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.accessor.IStructuralFeatureAccessor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.actions.ActionFactory;

public abstract class EMFCompareContentMergeViewer
extends ContentMergeViewer
implements ISelectionChangedListener,
ICompareColorProvider {
    private static final String HANDLER_SERVICE = "fHandlerService";
    protected static final int HORIZONTAL = 1;
    protected static final int VERTICAL = 2;
    protected static final double HSPLIT = 0.5;
    protected static final double VSPLIT = 0.3;
    protected static final int CENTER_WIDTH = 34;
    private MergeViewer fAncestor;
    private MergeViewer fLeft;
    private MergeViewer fRight;
    private ActionContributionItem fCopyDiffLeftToRightItem;
    private ActionContributionItem fCopyDiffRightToLeftItem;
    private final Comparison fComparison;
    private final AtomicBoolean fSyncingSelections = new AtomicBoolean(false);
    private EMFCompareColor fColors;
    private final EMFCompareEditingDomain fEditingDomain;
    private final DynamicObject fDynamicObject = new DynamicObject((Object)this);

    protected EMFCompareContentMergeViewer(int style, ResourceBundle bundle, CompareConfiguration cc) {
        super(style, bundle, cc);
        this.fComparison = ((ComparisonNode)((Object)cc.getProperty("org.eclipse.emf.compare.ide.ui.COMPARE.RESULT"))).getTarget();
        this.fEditingDomain = (EMFCompareEditingDomain)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.ide.ui.EDITING_DOMAIN");
    }

    public ICompareColor getCompareColor() {
        return this.fColors;
    }

    protected final EMFCompareEditingDomain getEditingDomain() {
        return this.fEditingDomain;
    }

    protected final Comparison getComparison() {
        return this.fComparison;
    }

    public boolean isThreeWay() {
        return super.isThreeWay();
    }

    protected void updateContent(Object ancestor, Object left, Object right) {
        this.fAncestor.setInput(ancestor);
        this.fLeft.setInput(left);
        this.fRight.setInput(right);
        IMergeViewerItem leftInitialItem = null;
        if (left instanceof IStructuralFeatureAccessor) {
            leftInitialItem = ((IStructuralFeatureAccessor)left).getInitialItem();
        }
        ISelection leftSelection = this.createSelectionOrEmpty(leftInitialItem);
        this.fLeft.setSelection(leftSelection);
        this.getCenterControl().redraw();
    }

    private ISelection createSelectionOrEmpty(Object o) {
        StructuredSelection selection = o != null ? new StructuredSelection(o) : StructuredSelection.EMPTY;
        return selection;
    }

    protected boolean doSave(Object newInput, Object oldInput) {
        return false;
    }

    protected void createControls(Composite composite) {
        this.fAncestor = this.createMergeViewer(composite, MergeViewer.MergeViewerSide.ANCESTOR);
        this.fAncestor.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fLeft = this.createMergeViewer(composite, MergeViewer.MergeViewerSide.LEFT);
        this.fLeft.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fRight = this.createMergeViewer(composite, MergeViewer.MergeViewerSide.RIGHT);
        this.fRight.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fColors = new EMFCompareColor(this, null, this.getCompareConfiguration());
    }

    protected void createToolItems(ToolBarManager toolBarManager) {
        Action a;
        CompareConfiguration cc = this.getCompareConfiguration();
        if (cc.isRightEditable()) {
            a = new Action(){

                public void run() {
                    EMFCompareContentMergeViewer.this.copyDiffLeftToRight();
                }
            };
            Utilities.initAction((IAction)a, (ResourceBundle)this.getResourceBundle(), (String)"action.CopyDiffLeftToRight.");
            this.fCopyDiffLeftToRightItem = new ActionContributionItem((IAction)a);
            this.fCopyDiffLeftToRightItem.setVisible(true);
            toolBarManager.appendToGroup("merge", (IContributionItem)this.fCopyDiffLeftToRightItem);
            this.getHandlerService().registerAction((IAction)a, "org.eclipse.compare.copyLeftToRight");
        }
        if (cc.isLeftEditable()) {
            a = new Action(){

                public void run() {
                    EMFCompareContentMergeViewer.this.copyDiffRightToLeft();
                }
            };
            Utilities.initAction((IAction)a, (ResourceBundle)this.getResourceBundle(), (String)"action.CopyDiffRightToLeft.");
            this.fCopyDiffRightToLeftItem = new ActionContributionItem((IAction)a);
            this.fCopyDiffRightToLeftItem.setVisible(true);
            toolBarManager.appendToGroup("merge", (IContributionItem)this.fCopyDiffRightToLeftItem);
            this.getHandlerService().registerAction((IAction)a, "org.eclipse.compare.copyRightToLeft");
        }
        final UndoAction undoAction = new UndoAction(this.fEditingDomain);
        final RedoAction redoAction = new RedoAction(this.fEditingDomain);
        this.fEditingDomain.getCommandStack().addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                undoAction.update();
                redoAction.update();
                EMFCompareContentMergeViewer.this.refresh();
            }
        });
        this.getHandlerService().setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)undoAction);
        this.getHandlerService().setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)redoAction);
    }

    protected abstract void copyDiffRightToLeft();

    protected abstract void copyDiffLeftToRight();

    protected void handleResizeAncestor(int x, int y, int width, int height) {
        if (width > 0) {
            this.getAncestorMergeViewer().getControl().setVisible(true);
            this.getAncestorMergeViewer().getControl().setBounds(x, y, width, height);
        } else {
            this.getAncestorMergeViewer().getControl().setVisible(false);
        }
    }

    protected void handleResizeLeftRight(int x, int y, int width1, int centerWidth, int width2, int height) {
        this.fLeft.getControl().setBounds(x, y, width1, height);
        this.fRight.getControl().setBounds(x + width1 + centerWidth, y, width2, height);
    }

    protected abstract MergeViewer createMergeViewer(Composite var1, MergeViewer.MergeViewerSide var2);

    protected final int getCenterWidth() {
        return 34;
    }

    protected final CompareHandlerService getHandlerService() {
        return (CompareHandlerService)this.fDynamicObject.get(HANDLER_SERVICE);
    }

    public Composite getControl() {
        return (Composite)super.getControl();
    }

    protected Control createCenterControl(Composite parent) {
        final Control ret = super.createCenterControl(parent);
        final PaintListener paintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                EMFCompareContentMergeViewer.this.paintCenter(e.gc);
            }
        };
        ret.addPaintListener(paintListener);
        ret.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ret.removePaintListener(paintListener);
            }
        });
        new Resizer(ret);
        return ret;
    }

    protected abstract void paintCenter(GC var1);

    protected MergeViewer getAncestorMergeViewer() {
        return this.fAncestor;
    }

    protected MergeViewer getLeftMergeViewer() {
        return this.fLeft;
    }

    protected MergeViewer getRightMergeViewer() {
        return this.fRight;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.fSyncingSelections.compareAndSet(false, true)) {
            try {
                ISelectionProvider selectionProvider = event.getSelectionProvider();
                ISelection selection = event.getSelection();
                this.synchronizeSelection(selectionProvider, selection);
            }
            finally {
                this.fSyncingSelections.set(false);
            }
        }
    }

    private void synchronizeSelection(ISelectionProvider selectionProvider, ISelection selection) {
        if (selectionProvider == this.fLeft) {
            this.fRight.setSelection(selection);
            this.fAncestor.setSelection(selection);
        } else if (selectionProvider == this.fRight) {
            this.fLeft.setSelection(selection);
            this.fAncestor.setSelection(selection);
        } else {
            this.fLeft.setSelection(selection);
            this.fRight.setSelection(selection);
        }
    }

    private class Resizer
    extends MouseAdapter
    implements MouseMoveListener {
        Control fControl;
        boolean fIsDown;

        public Resizer(Control c) {
            this.fControl = c;
            this.fControl.addMouseListener((MouseListener)this);
            this.fControl.addMouseMoveListener((MouseMoveListener)this);
            this.fControl.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    Resizer.this.fControl = null;
                }
            });
        }

        public void mouseDoubleClick(MouseEvent e) {
            EMFCompareContentMergeViewer.this.getControl().layout(true);
        }

        public void mouseDown(MouseEvent e) {
            this.fIsDown = true;
        }

        public void mouseUp(MouseEvent e) {
            this.fIsDown = false;
            this.resize();
        }

        public void mouseMove(MouseEvent e) {
            if (this.fIsDown) {
                this.resize();
            }
        }

        private void resize() {
            EMFCompareContentMergeViewer.this.getControl().layout(true);
            this.fControl.getDisplay().update();
        }
    }
}

