/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.table;

import java.util.Collection;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.EMFCompareContentMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.table.TableContentMergeViewerContentProvider;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.ICompareColorProvider;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.MatchedObject;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.MergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.TableMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.accessor.IStructuralFeatureAccessor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.GestureEvent;
import org.eclipse.swt.events.GestureListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableContentMergeViewer
extends EMFCompareContentMergeViewer {
    private static final String BUNDLE_NAME = TableContentMergeViewer.class.getName();
    private final ComposedAdapterFactory fAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private double[] fBasicCenterCurve;

    protected TableContentMergeViewer(Composite parent, CompareConfiguration config) {
        super(0, ResourceBundle.getBundle(BUNDLE_NAME), config);
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.buildControl(parent);
        this.setContentProvider((IContentProvider)new TableContentMergeViewerContentProvider(config));
    }

    protected void handleDispose(DisposeEvent event) {
        this.fAdapterFactory.dispose();
        super.handleDispose(event);
    }

    protected void copy(boolean leftToRight) {
        EList differences = this.getComparison().getDifferences();
        Command copyCommand = leftToRight ? this.getEditingDomain().createCopyAllNonConflictingLeftToRightCommand((Collection<? extends Diff>)differences) : this.getEditingDomain().createCopyAllNonConflictingRightToLeftCommand((Collection<? extends Diff>)differences);
        this.getEditingDomain().getCommandStack().execute(copyCommand);
        if (leftToRight) {
            this.setRightDirty(true);
        } else {
            this.setLeftDirty(true);
        }
        this.refresh();
    }

    protected byte[] getContents(boolean left) {
        return null;
    }

    protected void copyDiffRightToLeft() {
        Diff diffToCopy = this.getDiffToCopy((MergeViewer)this.getRightMergeViewer());
        if (diffToCopy != null) {
            Command copyCommand = this.getEditingDomain().createCopyRightToLeftCommand(diffToCopy);
            this.getEditingDomain().getCommandStack().execute(copyCommand);
            this.setLeftDirty(true);
            this.refresh();
        }
    }

    private Diff getDiffToCopy(MergeViewer mergeViewer) {
        Object firstElement;
        Diff diffToCopy = null;
        ISelection selection = mergeViewer.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof IMergeViewerItem) {
            diffToCopy = ((IMergeViewerItem)firstElement).getDiff();
        }
        return diffToCopy;
    }

    protected void copyDiffLeftToRight() {
        Diff diffToCopy = this.getDiffToCopy((MergeViewer)this.getLeftMergeViewer());
        if (diffToCopy != null) {
            Command copyCommand = this.getEditingDomain().createCopyLeftToRightCommand(diffToCopy);
            this.getEditingDomain().getCommandStack().execute(copyCommand);
            this.setRightDirty(true);
            this.refresh();
        }
    }

    protected TableMergeViewer getLeftMergeViewer() {
        return (TableMergeViewer)super.getLeftMergeViewer();
    }

    protected TableMergeViewer getRightMergeViewer() {
        return (TableMergeViewer)super.getRightMergeViewer();
    }

    protected TableMergeViewer getAncestorMergeViewer() {
        return (TableMergeViewer)super.getAncestorMergeViewer();
    }

    protected MergeViewer createMergeViewer(Composite parent, final MergeViewer.MergeViewerSide side) {
        TableMergeViewer ret = new TableMergeViewer(parent, side, (ICompareColorProvider)this);
        ret.getStructuredViewer().getTable().getVerticalBar().setVisible(false);
        ret.setContentProvider((IContentProvider)new ArrayContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof IStructuralFeatureAccessor) {
                    return super.getElements((Object)((IStructuralFeatureAccessor)inputElement).getItems());
                }
                return super.getElements(inputElement);
            }
        });
        ret.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider.FontAndColorProvider((AdapterFactory)this.fAdapterFactory, (Viewer)ret.getStructuredViewer()){

            public Font getFont(Object object) {
                Font font = super.getFont(object);
                if (object instanceof EObject && ((EObject)object).eIsProxy()) {
                    return this.getFontFromObject(IItemFontProvider.ITALIC_FONT);
                }
                return font;
            }

            public String getColumnText(Object object, int columnIndex) {
                if (object instanceof MatchedObject) {
                    return super.getColumnText(((MatchedObject)object).getSideValue(side), columnIndex);
                }
                return super.getColumnText(object, columnIndex);
            }

            public Image getColumnImage(Object object, int columnIndex) {
                if (object instanceof MatchedObject) {
                    return super.getColumnImage(((MatchedObject)object).getSideValue(side), columnIndex);
                }
                return super.getColumnImage(object, columnIndex);
            }
        });
        ret.getStructuredViewer().getTable().getVerticalBar().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableContentMergeViewer.this.redrawCenterControl();
            }
        });
        ret.getStructuredViewer().getTable().addGestureListener(new GestureListener(){

            public void gesture(GestureEvent e) {
                if (e.detail == 64) {
                    TableContentMergeViewer.this.redrawCenterControl();
                }
            }
        });
        ret.getStructuredViewer().getTable().addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                TableContentMergeViewer.this.redrawCenterControl();
            }
        });
        ret.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TableContentMergeViewer.this.redrawCenterControl();
            }
        });
        return ret;
    }

    protected void redrawCenterControl() {
        this.getCenterControl().redraw();
    }

    protected void paintCenter(GC g) {
        TableMergeViewer leftMergeViewer = this.getLeftMergeViewer();
        TableMergeViewer rightMergeViewer = this.getRightMergeViewer();
        Table leftTable = leftMergeViewer.getStructuredViewer().getTable();
        Table rightTable = rightMergeViewer.getStructuredViewer().getTable();
        Rectangle leftClientArea = leftTable.getClientArea();
        Rectangle rightClientArea = rightTable.getClientArea();
        TableItem[] leftItems = leftTable.getItems();
        TableItem[] rightItems = rightTable.getItems();
        TableItem[] selection = leftTable.getSelection();
        TableItem[] tableItemArray = leftItems;
        int n = leftItems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem rightItem;
            TableItem leftItem = tableItemArray[n2];
            boolean selected = selection.length > 0 ? leftItem == selection[0] : false;
            Diff leftDiff = ((IMergeViewerItem)leftItem.getData()).getDiff();
            if (leftDiff != null && leftDiff.getState() == DifferenceState.UNRESOLVED && (rightItem = this.findRightTableItemFromLeftDiff(rightItems, leftDiff)) != null) {
                Color strokeColor = this.getCompareColor().getStrokeColor(leftDiff, this.isThreeWay(), false, selected);
                g.setForeground(strokeColor);
                this.drawCenterLine(g, leftClientArea, rightClientArea, leftItem, rightItem);
            }
            ++n2;
        }
    }

    private void drawCenterLine(GC g, Rectangle leftClientArea, Rectangle rightClientArea, TableItem leftItem, TableItem rightItem) {
        Control control = this.getCenterControl();
        Point from = new Point(0, 0);
        Point to = new Point(0, 0);
        Rectangle leftBounds = leftItem.getBounds();
        Rectangle rightBounds = rightItem.getBounds();
        from.y = leftBounds.y + leftBounds.height / 2 - leftClientArea.y + 1 + this.getLeftMergeViewer().getVerticalOffset();
        to.x = control.getBounds().width;
        to.y = rightBounds.y + rightBounds.height / 2 - rightClientArea.y + 1 + this.getRightMergeViewer().getVerticalOffset();
        int[] points = this.getCenterCurvePoints(from, to);
        int i = 1;
        while (i < points.length) {
            g.drawLine(from.x + i - 1, points[i - 1], i, points[i]);
            ++i;
        }
    }

    private TableItem findRightTableItemFromLeftDiff(TableItem[] rightItems, Diff leftDiff) {
        TableItem ret = null;
        int i = 0;
        while (i < rightItems.length && ret == null) {
            TableItem rightItem = rightItems[i];
            Diff rightDiff = ((IMergeViewerItem)rightItem.getData()).getDiff();
            if (leftDiff == rightDiff) {
                ret = rightItem;
            }
            ++i;
        }
        return ret;
    }

    private int[] getCenterCurvePoints(Point from, Point to) {
        int startx = from.x;
        int starty = from.y;
        int endx = to.x;
        int endy = to.y;
        if (this.fBasicCenterCurve == null) {
            this.buildBaseCenterCurve(endx - startx);
        }
        double height = endy - starty;
        height /= 2.0;
        int width = endx - startx;
        int[] points = new int[width];
        int i = 0;
        while (i < width) {
            points[i] = (int)(-height * this.fBasicCenterCurve[i] + height + (double)starty);
            ++i;
        }
        return points;
    }

    private void buildBaseCenterCurve(int w) {
        double width = w;
        this.fBasicCenterCurve = new double[this.getCenterWidth()];
        int i = 0;
        while (i < this.getCenterWidth()) {
            double r = (double)i / width;
            this.fBasicCenterCurve[i] = Math.cos(Math.PI * r);
            ++i;
        }
    }
}

