/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.text;

import java.util.EventObject;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.CompareHandlerService;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.text.EMFCompareTextMergeViewerContentProvider;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.DynamicObject;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.AttributeChangeNode;
import org.eclipse.emf.compare.ide.ui.internal.util.EMFCompareEditingDomain;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class EMFCompareTextMergeViewer
extends TextMergeViewer
implements CommandStackListener {
    private static final String BUNDLE_NAME = EMFCompareTextMergeViewer.class.getName();
    private final EMFCompareEditingDomain fEditingDomain = (EMFCompareEditingDomain)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.ide.ui.EDITING_DOMAIN");
    private DynamicObject fDynamicObject;

    public EMFCompareTextMergeViewer(Composite parent, CompareConfiguration configuration) {
        super(parent, configuration);
        this.fEditingDomain.getCommandStack().addCommandStackListener((CommandStackListener)this);
        this.setContentProvider((IContentProvider)new EMFCompareTextMergeViewerContentProvider(configuration));
    }

    protected void copy(boolean leftToRight) {
        AttributeChange attributeChange;
        Object input = this.getInput();
        if (input instanceof AttributeChangeNode && (attributeChange = ((AttributeChangeNode)((Object)input)).getTarget()).getState() == DifferenceState.UNRESOLVED) {
            Command copyCommand = leftToRight ? this.fEditingDomain.createCopyLeftToRightCommand((Diff)attributeChange) : this.fEditingDomain.createCopyRightToLeftCommand((Diff)attributeChange);
            this.fEditingDomain.getCommandStack().execute(copyCommand);
            if (leftToRight) {
                this.setRightDirty(true);
            } else {
                this.setLeftDirty(true);
            }
            this.refresh();
        }
    }

    protected boolean doSave(Object newInput, Object oldInput) {
        return false;
    }

    protected void handleDispose(DisposeEvent event) {
        this.fEditingDomain.getCommandStack().removeCommandStackListener((CommandStackListener)this);
        super.handleDispose(event);
    }

    public DynamicObject getDynamicObject() {
        if (this.fDynamicObject == null) {
            this.fDynamicObject = new DynamicObject((Object)this);
        }
        return this.fDynamicObject;
    }

    protected final MergeSourceViewer getLeftSourceViewer() {
        return (MergeSourceViewer)this.getDynamicObject().get("fLeft");
    }

    protected final MergeSourceViewer getRightSourceViewer() {
        return (MergeSourceViewer)this.getDynamicObject().get("fRight");
    }

    protected final void setHandlerService(CompareHandlerService service) {
        this.getDynamicObject().set("fHandlerService", service);
    }

    protected void createToolItems(ToolBarManager tbm) {
        this.setHandlerService(CompareHandlerService.createFor((ICompareContainer)this.getCompareConfiguration().getContainer(), (Shell)this.getLeftSourceViewer().getSourceViewer().getControl().getShell()));
    }

    protected void setEditable(ISourceViewer sourceViewer, boolean state) {
        sourceViewer.setEditable(false);
    }

    protected ResourceBundle getResourceBundle() {
        return ResourceBundle.getBundle(BUNDLE_NAME);
    }

    public void commandStackChanged(EventObject event) {
        this.refresh();
    }
}

