/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree;

import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.EMFCompareContentMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree.TreeMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree.TreeMergeViewerContentProvider;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.MergeViewer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;

public class TreeContentMergeViewer
extends EMFCompareContentMergeViewer {
    private static final String BUNDLE_NAME = TreeContentMergeViewer.class.getName();
    private final ComposedAdapterFactory fAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);

    public TreeContentMergeViewer(Composite parent, CompareConfiguration config) {
        super(0, ResourceBundle.getBundle(BUNDLE_NAME), config);
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.buildControl(parent);
        this.setContentProvider((IContentProvider)new TreeMergeViewerContentProvider(config));
    }

    protected void handleDispose(DisposeEvent event) {
        this.fAdapterFactory.dispose();
        super.handleDispose(event);
    }

    protected TreeMergeViewer getAncestorMergeViewer() {
        return (TreeMergeViewer)super.getAncestorMergeViewer();
    }

    protected TreeMergeViewer getLeftMergeViewer() {
        return (TreeMergeViewer)super.getLeftMergeViewer();
    }

    protected TreeMergeViewer getRightMergeViewer() {
        return (TreeMergeViewer)super.getRightMergeViewer();
    }

    protected void copy(boolean leftToRight) {
    }

    protected void copyDiffLeftToRight() {
        IStructuredSelection selection = (IStructuredSelection)this.getLeftMergeViewer().getSelection();
        Object firstElement = selection.getFirstElement();
        EList differences = this.getComparison().getDifferences((EObject)firstElement);
        for (Diff diff : differences) {
            if (diff.getSource() != DifferenceSource.LEFT) continue;
            diff.copyLeftToRight();
        }
    }

    protected void copyDiffRightToLeft() {
        IStructuredSelection selection = (IStructuredSelection)this.getRightMergeViewer().getSelection();
        Object firstElement = selection.getFirstElement();
        EList differences = this.getComparison().getDifferences((EObject)firstElement);
        for (Diff diff : differences) {
            if (diff.getSource() != DifferenceSource.RIGHT) continue;
            diff.copyRightToLeft();
        }
    }

    protected byte[] getContents(boolean left) {
        return null;
    }

    protected MergeViewer createMergeViewer(Composite parent, MergeViewer.MergeViewerSide side) {
        TreeMergeViewer mergeTreeViewer = new TreeMergeViewer(parent, side);
        AdapterFactoryContentProvider contentProvider = new AdapterFactoryContentProvider((AdapterFactory)this.fAdapterFactory);
        mergeTreeViewer.setContentProvider((IContentProvider)contentProvider);
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.fAdapterFactory);
        mergeTreeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        return mergeTreeViewer;
    }

    protected void paintCenter(GC g) {
    }
}

