/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.AbstractEDiffNode;
import org.eclipse.emf.compare.utils.EMFComparePredicates;

public class DiffNode
extends AbstractEDiffNode {
    public DiffNode(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Diff getTarget() {
        return (Diff)super.getTarget();
    }

    public int getKind() {
        int ret = 0;
        Diff diff = this.getTarget();
        DifferenceSource source = diff.getSource();
        Match match = diff.getMatch();
        Conflict conflict = diff.getConflict();
        DifferenceKind diffKind = diff.getKind();
        Comparison c = match.getComparison();
        if (c.isThreeWay()) {
            switch (source) {
                case LEFT: {
                    ret |= 4;
                    break;
                }
                case RIGHT: {
                    ret |= 8;
                    break;
                }
            }
            if (conflict != null) {
                ret |= 0xC;
                if (conflict.getKind() == ConflictKind.PSEUDO) {
                    ret |= 0x10;
                }
            } else if (Iterables.any((Iterable)diff.getRequiredBy(), (Predicate)EMFComparePredicates.hasRealConflict())) {
                ret |= 0xC;
            } else if (Iterables.any((Iterable)diff.getRequiredBy(), (Predicate)EMFComparePredicates.hasPseudoConflict())) {
                ret |= 0x1C;
            }
            switch (diffKind) {
                case ADD: {
                    ret |= 1;
                    break;
                }
                case DELETE: {
                    ret |= 2;
                    break;
                }
                case CHANGE: 
                case MOVE: {
                    ret |= 3;
                    break;
                }
            }
        } else {
            switch (diffKind) {
                case ADD: {
                    ret |= 2;
                    break;
                }
                case DELETE: {
                    ret |= 1;
                    break;
                }
                case CHANGE: 
                case MOVE: {
                    ret |= 3;
                    break;
                }
            }
        }
        return ret;
    }
}

