/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;

public class ImageProvider {
    private final boolean fLeftIsLocal;
    private static final Predicate<Diff> CONFLICTUAL_DIFF = new Predicate<Diff>(){

        public boolean apply(Diff input) {
            return input != null && input.getConflict() != null;
        }
    };
    private static final Predicate<Diff> PSEUDO_CONFLICT = new Predicate<Diff>(){

        public boolean apply(Diff input) {
            return input != null && input.getConflict().getKind() == ConflictKind.REAL;
        }
    };
    private static final Predicate<Diff> LEFT_DIFF = new Predicate<Diff>(){

        public boolean apply(Diff input) {
            return input != null && input.getSource() == DifferenceSource.LEFT;
        }
    };
    private static final Predicate<Diff> RIGHT_DIFF = new Predicate<Diff>(){

        public boolean apply(Diff input) {
            return input != null && input.getSource() == DifferenceSource.RIGHT;
        }
    };

    public ImageProvider(boolean leftIsLocal) {
        this.fLeftIsLocal = leftIsLocal;
    }

    public ImageDescriptor getImageDescriptorOverlay(Diff diff) {
        DifferenceSource source = diff.getSource();
        Match match = diff.getMatch();
        Conflict conflict = diff.getConflict();
        DifferenceKind diffKind = diff.getKind();
        Comparison c = match.getComparison();
        String path = "/icons/full/ovr16/";
        if (diff.getState() == DifferenceState.MERGED) {
            path = String.valueOf(path) + "merged_ov.gif";
        } else if (diff.getState() == DifferenceState.DISCARDED) {
            path = String.valueOf(path) + "removed_ov.gif";
        } else if (c.isThreeWay()) {
            String filext = ".gif";
            if (conflict != null) {
                if (conflict.getKind() == ConflictKind.REAL) {
                    filext = ".png";
                    path = String.valueOf(path) + "conf";
                    path = String.valueOf(path) + this.getConflictWay(source);
                }
            } else {
                switch (source) {
                    case LEFT: {
                        if (this.fLeftIsLocal) {
                            path = String.valueOf(path) + "r_out";
                            break;
                        }
                        path = String.valueOf(path) + "out";
                        break;
                    }
                    case RIGHT: {
                        if (this.fLeftIsLocal) {
                            path = String.valueOf(path) + "r_in";
                            break;
                        }
                        path = String.valueOf(path) + "in";
                        break;
                    }
                }
            }
            switch (diffKind) {
                case ADD: {
                    path = String.valueOf(path) + "add_ov";
                    break;
                }
                case DELETE: {
                    path = String.valueOf(path) + "del_ov";
                    break;
                }
                case CHANGE: 
                case MOVE: {
                    path = String.valueOf(path) + "chg_ov";
                    break;
                }
            }
            path = String.valueOf(path) + filext;
        } else {
            path = String.valueOf(path) + this.getPathForTwoWayDiff(diffKind);
        }
        return EMFCompareIDEUIPlugin.getDefault().getImageDescriptor(path);
    }

    private String getPathForTwoWayDiff(DifferenceKind diffKind) {
        String path;
        switch (diffKind) {
            case ADD: {
                if (this.fLeftIsLocal) {
                    path = "add_ov.gif";
                    break;
                }
                path = "del_ov.gif";
                break;
            }
            case DELETE: {
                if (this.fLeftIsLocal) {
                    path = "del_ov.gif";
                    break;
                }
                path = "add_ov.gif";
                break;
            }
            case CHANGE: 
            case MOVE: {
                path = "chg_ov.gif";
                break;
            }
            default: {
                path = "";
            }
        }
        return path;
    }

    private String getConflictWay(DifferenceSource source) {
        String path = source == DifferenceSource.LEFT && !this.fLeftIsLocal ? "r_" : (source == DifferenceSource.RIGHT && this.fLeftIsLocal ? "r_" : "");
        return path;
    }

    public ImageDescriptor getImageDescriptorOverlay(Match match) {
        String path = null;
        EObject ancestor = match.getOrigin();
        EObject left = match.getLeft();
        EObject right = match.getRight();
        Iterable differences = match.getAllDifferences();
        if (match.getComparison().isThreeWay()) {
            Iterable conflictualDiffs = Iterables.filter((Iterable)differences, CONFLICTUAL_DIFF);
            if (ancestor == null) {
                if (left == null) {
                    if (right != null) {
                        path = this.fLeftIsLocal ? "r_inadd_ov.gif" : "inadd_ov.gif";
                    }
                } else if (right == null) {
                    path = this.fLeftIsLocal ? "r_outadd_ov.gif" : "outadd_ov.gif";
                } else if (!Iterables.isEmpty((Iterable)conflictualDiffs)) {
                    path = "confadd_ov.png";
                    Iterables.all((Iterable)conflictualDiffs, PSEUDO_CONFLICT);
                }
            } else if (left == null) {
                if (right != null) {
                    if (Iterables.isEmpty((Iterable)conflictualDiffs)) {
                        path = this.fLeftIsLocal ? "r_outdel_ov.gif" : "outdel_ov.gif";
                    } else if (!Iterables.isEmpty((Iterable)conflictualDiffs)) {
                        path = "confdel_ov.png";
                        Iterables.all((Iterable)conflictualDiffs, PSEUDO_CONFLICT);
                    }
                }
            } else if (right == null) {
                if (Iterables.isEmpty((Iterable)conflictualDiffs)) {
                    path = this.fLeftIsLocal ? "r_indel_ov.gif" : "indel_ov.gif";
                } else if (!Iterables.isEmpty((Iterable)conflictualDiffs)) {
                    path = "confchg_ov.png";
                    Iterables.all((Iterable)conflictualDiffs, PSEUDO_CONFLICT);
                }
            } else {
                boolean ay = Iterables.isEmpty((Iterable)Iterables.filter((Iterable)differences, LEFT_DIFF));
                boolean am = Iterables.isEmpty((Iterable)Iterables.filter((Iterable)differences, RIGHT_DIFF));
                if (!Iterables.isEmpty((Iterable)differences)) {
                    if (ay && !am) {
                        path = this.fLeftIsLocal ? "r_inchg_ov.gif" : "inchg_ov.gif";
                    } else if (!ay && am) {
                        path = this.fLeftIsLocal ? "r_outchg_ov.gif" : "outchg_ov.gif";
                    } else if (!Iterables.isEmpty((Iterable)conflictualDiffs)) {
                        path = "confchg_ov.png";
                        Iterables.all((Iterable)conflictualDiffs, PSEUDO_CONFLICT);
                    }
                }
            }
        } else if (left == null) {
            if (right != null) {
                path = this.fLeftIsLocal ? "add_ov.gif" : "del_ov.gif";
            }
        } else if (right == null) {
            path = this.fLeftIsLocal ? "del_ov.gif" : "add_ov.gif";
        } else if (!Iterables.isEmpty((Iterable)differences)) {
            path = "chg_ov.gif";
        }
        ImageDescriptor ret = null;
        if (path != null) {
            ret = EMFCompareIDEUIPlugin.getDefault().getImageDescriptor("/icons/full/ovr16/" + path);
        }
        return ret;
    }
}

