/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.util;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.edit.command.ChangeCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFCompareEditingDomain {
    private final ChangeRecorder fChangeRecorder;
    private final ImmutableCollection<Notifier> fNotifiers;
    private final BasicCommandStack fCommandStack;

    public EMFCompareEditingDomain(Comparison comparison, Notifier left, Notifier right, Notifier ancestor) {
        this.fNotifiers = ancestor == null ? ImmutableList.of((Object)comparison, (Object)left, (Object)right) : ImmutableList.of((Object)comparison, (Object)left, (Object)right, (Object)ancestor);
        this.fCommandStack = new BasicCommandStack();
        this.fChangeRecorder = new ChangeRecorder();
        this.fChangeRecorder.setResolveProxies(false);
        for (Notifier notifier : this.fNotifiers) {
            notifier.eAdapters().add((Object)this.fChangeRecorder);
        }
    }

    public void dispose() {
        this.fChangeRecorder.dispose();
    }

    public BasicCommandStack getCommandStack() {
        return this.fCommandStack;
    }

    public Command createCopyRightToLeftCommand(Diff diff) {
        return new CopyRightToLeftCommand(this.fChangeRecorder, (Collection)this.fNotifiers, diff);
    }

    public Command createCopyLeftToRightCommand(Diff diff) {
        return new CopyLeftToRightCommand(this.fChangeRecorder, (Collection)this.fNotifiers, diff);
    }

    public Command createCopyAllNonConflictingRightToLeftCommand(Collection<? extends Diff> diff) {
        return new CopyAllNonConflictingRightToLeftCommand(this.fChangeRecorder, (Collection<Notifier>)this.fNotifiers, diff);
    }

    public Command createCopyAllNonConflictingLeftToRightCommand(Collection<? extends Diff> diff) {
        return new CopyAllNonConflictingLeftToRightCommand(this.fChangeRecorder, (Collection<Notifier>)this.fNotifiers, diff);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CopyAllNonConflictingLeftToRightCommand
    extends ChangeCommand {
        private final Collection<? extends Diff> fDiff;

        public CopyAllNonConflictingLeftToRightCommand(ChangeRecorder changeRecorder, Collection<Notifier> notifiers, Collection<? extends Diff> diff) {
            super(changeRecorder, notifiers);
            this.fDiff = diff;
        }

        public boolean canExecute() {
            return Iterables.any(this.fDiff, (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})) && super.canExecute();
        }

        protected void doExecute() {
            for (Diff diff : this.fDiff) {
                if (diff.getSource() != DifferenceSource.LEFT || diff.getState() != DifferenceState.UNRESOLVED || diff.getConflict() != null && diff.getConflict().getKind() != ConflictKind.PSEUDO) continue;
                diff.copyLeftToRight();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CopyAllNonConflictingRightToLeftCommand
    extends ChangeCommand {
        private final Collection<? extends Diff> fDiff;

        public CopyAllNonConflictingRightToLeftCommand(ChangeRecorder changeRecorder, Collection<Notifier> notifiers, Collection<? extends Diff> diff) {
            super(changeRecorder, notifiers);
            this.fDiff = diff;
        }

        public boolean canExecute() {
            return Iterables.any(this.fDiff, (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})) && super.canExecute();
        }

        protected void doExecute() {
            for (Diff diff : this.fDiff) {
                if (diff.getSource() != DifferenceSource.RIGHT || diff.getState() != DifferenceState.UNRESOLVED || diff.getConflict() != null && diff.getConflict().getKind() != ConflictKind.PSEUDO) continue;
                diff.copyRightToLeft();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CopyLeftToRightCommand
    extends ChangeCommand {
        private final Diff fDiff;

        private CopyLeftToRightCommand(ChangeRecorder changeRecorder, Collection<Notifier> notifiers, Diff diff) {
            super(changeRecorder, notifiers);
            this.fDiff = diff;
        }

        public boolean canExecute() {
            return this.fDiff.getState() == DifferenceState.UNRESOLVED && super.canExecute();
        }

        protected void doExecute() {
            this.fDiff.copyLeftToRight();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CopyRightToLeftCommand
    extends ChangeCommand {
        private final Diff fDiff;

        private CopyRightToLeftCommand(ChangeRecorder changeRecorder, Collection<Notifier> notifiers, Diff diff) {
            super(changeRecorder, notifiers);
            this.fDiff = diff;
        }

        public boolean canExecute() {
            return this.fDiff.getState() == DifferenceState.UNRESOLVED && super.canExecute();
        }

        protected void doExecute() {
            this.fDiff.copyRightToLeft();
        }
    }
}

