/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare;

import com.google.common.base.Preconditions;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.utils.EqualityHelper;

public class EMFCompareConfiguration
extends AdapterImpl {
    private Monitor fMonitor;
    private EqualityHelper fEqualityHelper;
    private USE_IDS shouldUseIDs = USE_IDS.WHEN_AVAILABLE;

    EMFCompareConfiguration() {
    }

    public Monitor getMonitor() {
        return this.fMonitor;
    }

    public EqualityHelper getEqualityHelper() {
        return this.fEqualityHelper;
    }

    public USE_IDS matchByID() {
        return this.shouldUseIDs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isAdapterForType(Object type) {
        return type == EMFCompareConfiguration.class;
    }

    public static class Builder {
        private Monitor fMonitor;
        private EqualityHelper fEqualityHelper;
        private USE_IDS shouldUSEID;

        Builder() {
        }

        public Builder setMonitor(Monitor monitor) {
            Preconditions.checkNotNull((Object)monitor);
            this.fMonitor = monitor;
            return this;
        }

        public Builder setEqualityHelper(EqualityHelper equalityHelper) {
            Preconditions.checkNotNull((Object)equalityHelper);
            this.fEqualityHelper = equalityHelper;
            return this;
        }

        public Builder shouldUseID(USE_IDS strategy) {
            Preconditions.checkNotNull((Object)((Object)strategy));
            this.shouldUSEID = strategy;
            return this;
        }

        public EMFCompareConfiguration build() {
            EMFCompareConfiguration configuration = new EMFCompareConfiguration();
            if (this.fMonitor == null) {
                this.fMonitor = new BasicMonitor();
            }
            configuration.fMonitor = this.fMonitor;
            if (this.fEqualityHelper == null) {
                this.fEqualityHelper = new EqualityHelper();
            }
            configuration.fEqualityHelper = this.fEqualityHelper;
            if (this.shouldUSEID != null) {
                configuration.shouldUseIDs = this.shouldUSEID;
            }
            return configuration;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum USE_IDS {
        ONLY,
        WHEN_AVAILABLE,
        NEVER;

    }
}

