/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.conflict;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.conflict.IConflictDetector;
import org.eclipse.emf.compare.utils.EqualityHelper;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConflictDetector
implements IConflictDetector {
    private EqualityHelper helper;

    @Override
    public void detect(Comparison comparison) {
        this.helper = comparison.getConfiguration().getEqualityHelper();
        EList<Diff> differences = comparison.getDifferences();
        int diffCount = differences.size();
        int i = 0;
        while (i < diffCount) {
            Diff diff = (Diff)differences.get(i);
            ConflictCandidateFilter candidateFilter = new ConflictCandidateFilter(diff);
            this.checkConflict(comparison, diff, Iterables.filter(differences, (Predicate)candidateFilter));
            ++i;
        }
    }

    protected void checkConflict(Comparison comparison, Diff diff, Iterable<Diff> candidates) {
        if (diff instanceof ReferenceChange && ((ReferenceChange)diff).getReference().isContainment()) {
            this.checkContainmentConflict(comparison, (ReferenceChange)diff, Iterables.filter(candidates, ReferenceChange.class));
        } else {
            switch (diff.getKind()) {
                case DELETE: {
                    this.checkFeatureDeleteConflict(comparison, diff, candidates);
                    break;
                }
                case CHANGE: {
                    this.checkFeatureChangeConflict(comparison, diff, candidates);
                    break;
                }
                case MOVE: {
                    this.checkFeatureMoveConflict(comparison, diff, candidates);
                    break;
                }
                case ADD: {
                    this.checkFeatureAddConflict(comparison, diff, candidates);
                    break;
                }
            }
        }
    }

    protected void checkContainmentConflict(Comparison comparison, ReferenceChange diff, Iterable<ReferenceChange> candidates) {
        Match valueMatch = comparison.getMatch(diff.getValue());
        for (ReferenceChange candidate : candidates) {
            if (valueMatch.getLeft() != candidate.getValue() && valueMatch.getRight() != candidate.getValue() && valueMatch.getOrigin() != candidate.getValue()) continue;
            this.checkContainmentConflict(comparison, diff, candidate);
        }
        if (diff.getKind() == DifferenceKind.DELETE) {
            ConflictCandidateFilter candidateFilter = new ConflictCandidateFilter(diff);
            for (Diff extendedCandidate : Iterables.filter(valueMatch.getAllDifferences(), (Predicate)candidateFilter)) {
                if (DefaultConflictDetector.isDeleteOrUnsetDiff(comparison, extendedCandidate)) {
                    this.conflictOn(comparison, diff, extendedCandidate, ConflictKind.PSEUDO);
                    continue;
                }
                this.conflictOn(comparison, diff, extendedCandidate, ConflictKind.REAL);
            }
        }
    }

    protected void checkContainmentConflict(Comparison comparison, ReferenceChange diff, ReferenceChange candidate) {
        if (candidate.getReference().isContainment()) {
            ConflictKind kind = ConflictKind.REAL;
            boolean diffIsDelete = DefaultConflictDetector.isDeleteOrUnsetDiff(comparison, diff);
            boolean candidateIsDelete = DefaultConflictDetector.isDeleteOrUnsetDiff(comparison, candidate);
            if (diffIsDelete && candidateIsDelete) {
                kind = ConflictKind.PSEUDO;
            } else if (diff.getMatch() == candidate.getMatch() && diff.getReference() == candidate.getReference() && !diffIsDelete && !candidateIsDelete && this.matchingIndices(comparison, diff.getMatch(), (EStructuralFeature)diff.getReference(), diff.getValue(), candidate.getValue())) {
                kind = ConflictKind.PSEUDO;
            }
            this.conflictOn(comparison, diff, candidate, kind);
        } else if (diff.getKind() == DifferenceKind.DELETE && candidate.getKind() != DifferenceKind.DELETE) {
            this.conflictOn(comparison, diff, candidate, ConflictKind.REAL);
        }
    }

    protected void checkFeatureChangeConflict(Comparison comparison, Diff diff, Iterable<Diff> candidates) {
        EReference feature;
        Object changedValue;
        if (diff instanceof ReferenceChange) {
            changedValue = ((ReferenceChange)diff).getValue();
            feature = ((ReferenceChange)diff).getReference();
        } else {
            changedValue = ((AttributeChange)diff).getValue();
            feature = ((AttributeChange)diff).getAttribute();
        }
        Iterable refinedCandidates = Iterables.filter(candidates, (Predicate)new Predicate<Diff>((EStructuralFeature)feature){
            private final /* synthetic */ EStructuralFeature val$feature;
            {
                this.val$feature = eStructuralFeature;
            }

            public boolean apply(Diff input) {
                boolean apply = false;
                if (input != null && input.getKind() == DifferenceKind.CHANGE) {
                    if (input instanceof ReferenceChange) {
                        apply = ((ReferenceChange)input).getReference() == this.val$feature;
                    } else if (input instanceof AttributeChange) {
                        apply = ((AttributeChange)input).getAttribute() == this.val$feature;
                    }
                }
                return apply;
            }
        });
        for (Diff candidate : refinedCandidates) {
            Object candidateValue = candidate instanceof ReferenceChange ? ((ReferenceChange)candidate).getValue() : ((AttributeChange)candidate).getValue();
            if (diff.getMatch() != candidate.getMatch()) continue;
            if (this.helper.matchingValues(comparison, changedValue, candidateValue)) {
                this.conflictOn(comparison, diff, candidate, ConflictKind.PSEUDO);
                continue;
            }
            this.conflictOn(comparison, diff, candidate, ConflictKind.REAL);
        }
    }

    protected void checkFeatureMoveConflict(Comparison comparison, Diff diff, Iterable<Diff> candidates) {
        EReference feature;
        Object changedValue;
        if (diff instanceof ReferenceChange) {
            changedValue = ((ReferenceChange)diff).getValue();
            feature = ((ReferenceChange)diff).getReference();
        } else {
            changedValue = ((AttributeChange)diff).getValue();
            feature = ((AttributeChange)diff).getAttribute();
        }
        Iterable refinedCandidates = Iterables.filter(candidates, (Predicate)new Predicate<Diff>((EStructuralFeature)feature){
            private final /* synthetic */ EStructuralFeature val$feature;
            {
                this.val$feature = eStructuralFeature;
            }

            public boolean apply(Diff input) {
                boolean apply = false;
                if (input != null && input.getKind() == DifferenceKind.MOVE) {
                    if (input instanceof ReferenceChange) {
                        apply = ((ReferenceChange)input).getReference() == this.val$feature;
                    } else if (input instanceof AttributeChange) {
                        apply = ((AttributeChange)input).getAttribute() == this.val$feature;
                    }
                }
                return apply;
            }
        });
        for (Diff candidate : refinedCandidates) {
            Object candidateValue = candidate instanceof ReferenceChange ? ((ReferenceChange)candidate).getValue() : ((AttributeChange)candidate).getValue();
            if (diff.getMatch() != candidate.getMatch() || !this.helper.matchingValues(comparison, changedValue, candidateValue)) continue;
            if (this.matchingIndices(comparison, diff.getMatch(), (EStructuralFeature)feature, changedValue, candidateValue)) {
                this.conflictOn(comparison, diff, candidate, ConflictKind.PSEUDO);
                continue;
            }
            this.conflictOn(comparison, diff, candidate, ConflictKind.REAL);
        }
    }

    protected void checkFeatureDeleteConflict(Comparison comparison, Diff diff, Iterable<Diff> candidates) {
        EReference feature;
        Object deletedValue;
        if (diff instanceof ReferenceChange) {
            deletedValue = ((ReferenceChange)diff).getValue();
            feature = ((ReferenceChange)diff).getReference();
        } else {
            deletedValue = ((AttributeChange)diff).getValue();
            feature = ((AttributeChange)diff).getAttribute();
        }
        Iterable refinedCandidates = Iterables.filter(candidates, (Predicate)new Predicate<Diff>((EStructuralFeature)feature){
            private final /* synthetic */ EStructuralFeature val$feature;
            {
                this.val$feature = eStructuralFeature;
            }

            public boolean apply(Diff input) {
                boolean apply = false;
                if (input != null && (input.getKind() == DifferenceKind.MOVE || input.getKind() == DifferenceKind.DELETE)) {
                    if (input instanceof ReferenceChange) {
                        apply = ((ReferenceChange)input).getReference() == this.val$feature;
                    } else if (input instanceof AttributeChange) {
                        apply = ((AttributeChange)input).getAttribute() == this.val$feature;
                    }
                }
                return apply;
            }
        });
        for (Diff candidate : refinedCandidates) {
            Object movedValue = candidate instanceof ReferenceChange ? ((ReferenceChange)candidate).getValue() : ((AttributeChange)candidate).getValue();
            if (!this.helper.matchingValues(comparison, deletedValue, movedValue)) continue;
            if (candidate.getKind() == DifferenceKind.MOVE) {
                this.conflictOn(comparison, diff, candidate, ConflictKind.REAL);
                continue;
            }
            this.conflictOn(comparison, diff, candidate, ConflictKind.PSEUDO);
        }
    }

    protected void checkFeatureAddConflict(Comparison comparison, final Diff diff, Iterable<Diff> candidates) {
        EReference feature;
        Object addedValue;
        if (diff instanceof ReferenceChange) {
            addedValue = ((ReferenceChange)diff).getValue();
            feature = ((ReferenceChange)diff).getReference();
        } else {
            addedValue = ((AttributeChange)diff).getValue();
            feature = ((AttributeChange)diff).getAttribute();
        }
        Iterable refinedCandidates = Iterables.filter(candidates, (Predicate)new Predicate<Diff>((EStructuralFeature)feature){
            private final /* synthetic */ EStructuralFeature val$feature;
            {
                this.val$feature = eStructuralFeature;
            }

            public boolean apply(Diff input) {
                boolean apply = false;
                if (input != null && input.getKind() == DifferenceKind.ADD && diff.getMatch() == input.getMatch()) {
                    if (input instanceof ReferenceChange) {
                        apply = ((ReferenceChange)input).getReference() == this.val$feature;
                    } else if (input instanceof AttributeChange) {
                        apply = ((AttributeChange)input).getAttribute() == this.val$feature;
                    }
                }
                return apply;
            }
        });
        for (Diff candidate : refinedCandidates) {
            Object candidateValue = candidate instanceof ReferenceChange ? ((ReferenceChange)candidate).getValue() : ((AttributeChange)candidate).getValue();
            if (!feature.isUnique() || !this.helper.matchingValues(comparison, addedValue, candidateValue)) continue;
            if (this.matchingIndices(comparison, diff.getMatch(), (EStructuralFeature)feature, addedValue, candidateValue)) {
                this.conflictOn(comparison, diff, candidate, ConflictKind.PSEUDO);
                continue;
            }
            this.conflictOn(comparison, diff, candidate, ConflictKind.REAL);
        }
    }

    private static boolean isDeleteOrUnsetDiff(Comparison comparison, Diff diff) {
        boolean deleteOrUnset = false;
        if (diff.getKind() == DifferenceKind.DELETE) {
            deleteOrUnset = true;
        } else if (diff instanceof ReferenceChange) {
            EObject value = ((ReferenceChange)diff).getValue();
            Match valueMatch = comparison.getMatch(value);
            deleteOrUnset = valueMatch != null && valueMatch.getOrigin() == value;
        } else if (diff.getKind() == DifferenceKind.CHANGE && diff instanceof AttributeChange) {
            EAttribute attribute = ((AttributeChange)diff).getAttribute();
            EObject expectedContainer = diff.getSource() == DifferenceSource.LEFT ? diff.getMatch().getLeft() : diff.getMatch().getRight();
            Object value = expectedContainer.eGet((EStructuralFeature)attribute);
            Object defaultValue = attribute.getDefaultValue();
            deleteOrUnset = value == null || value.equals(defaultValue) || defaultValue == null && "".equals(value);
        }
        return deleteOrUnset;
    }

    private boolean matchingIndices(Comparison comparison, Match match, EStructuralFeature feature, Object value1, Object value2) {
        boolean matching = false;
        if (feature.isMany()) {
            List leftValues = (List)match.getLeft().eGet(feature);
            List rightValues = (List)match.getRight().eGet(feature);
            int i = 0;
            while (i < leftValues.size() && i < rightValues.size() && !matching) {
                Object left = leftValues.get(i);
                if (this.helper.matchingValues(comparison, left, value1)) {
                    Object right = rightValues.get(i);
                    matching = this.helper.matchingValues(comparison, right, value2);
                }
                ++i;
            }
            i = 0;
            while (i < leftValues.size() && i < rightValues.size() && !matching) {
                Object right = rightValues.get(i);
                if (this.helper.matchingValues(comparison, right, value1)) {
                    Object left = leftValues.get(i);
                    matching = this.helper.matchingValues(comparison, left, value2);
                }
                ++i;
            }
        } else {
            matching = true;
        }
        return matching;
    }

    protected void conflictOn(Comparison comparison, Diff diff1, Diff diff2, ConflictKind kind) {
        Conflict conflict;
        Conflict toBeMerged = null;
        if (diff1.getConflict() != null) {
            conflict = diff1.getConflict();
            if (conflict.getKind() == ConflictKind.PSEUDO && conflict.getKind() != kind) {
                conflict.setKind(kind);
            }
            if (diff2.getConflict() != null) {
                toBeMerged = diff2.getConflict();
            }
        } else if (diff2.getConflict() != null) {
            conflict = diff2.getConflict();
            if (conflict.getKind() == ConflictKind.PSEUDO && conflict.getKind() != kind) {
                conflict.setKind(kind);
            }
        } else {
            conflict = CompareFactory.eINSTANCE.createConflict();
            conflict.setKind(kind);
            comparison.getConflicts().add((Object)conflict);
        }
        EList<Diff> conflictDiffs = conflict.getDifferences();
        if (toBeMerged != null) {
            for (Diff aDiff : Lists.newArrayList(toBeMerged.getDifferences())) {
                if (conflictDiffs.contains(aDiff)) continue;
                conflictDiffs.add(aDiff);
            }
            if (toBeMerged.getKind() == ConflictKind.REAL && conflict.getKind() != ConflictKind.REAL) {
                conflict.setKind(ConflictKind.REAL);
            }
            EcoreUtil.remove((EObject)toBeMerged);
            toBeMerged.getDifferences().clear();
        }
        if (!conflict.getDifferences().contains((Object)diff1)) {
            conflict.getDifferences().add((Object)diff1);
        }
        if (!conflict.getDifferences().contains((Object)diff2)) {
            conflict.getDifferences().add((Object)diff2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConflictCandidateFilter
    implements Predicate<Diff> {
        private final Diff reference;

        public ConflictCandidateFilter(Diff reference) {
            this.reference = reference;
        }

        public boolean apply(Diff input) {
            return this.canConflictWith(this.reference, input);
        }

        private boolean canConflictWith(Diff diff1, Diff diff2) {
            if (diff1 == diff2 || diff1.getSource() == diff2.getSource()) {
                return false;
            }
            Conflict conflict = diff1.getConflict();
            return conflict == null || !conflict.getDifferences().contains((Object)diff2);
        }
    }
}

