/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.equi;

import com.google.common.collect.Iterables;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Equivalence;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.equi.IEquiEngine;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DefaultEquiEngine
implements IEquiEngine {
    public void computeEquivalences(Comparison comparison) {
        for (Diff difference : comparison.getDifferences()) {
            this.checkForEquivalences(comparison, difference);
        }
    }

    protected void checkForEquivalences(Comparison comparison, Diff difference) {
        ReferenceChange referenceChange;
        EReference reference;
        EReference eOpposite;
        if (difference instanceof ReferenceChange && (eOpposite = (reference = (referenceChange = (ReferenceChange)difference).getReference()).getEOpposite()) != null && !eOpposite.isContainer() && !eOpposite.isDerived()) {
            this.checkForEquivalences(comparison, referenceChange);
        }
    }

    protected void checkForEquivalences(Comparison comparison, ReferenceChange referenceChange) {
        Equivalence equivalence = referenceChange.getEquivalence();
        if (equivalence == null) {
            equivalence = CompareFactory.eINSTANCE.createEquivalence();
            comparison.getEquivalences().add((Object)equivalence);
            equivalence.getDifferences().add((Object)referenceChange);
            EObject container = MatchUtil.getContainer(comparison, referenceChange);
            if (container != null) {
                for (ReferenceChange diff : Iterables.filter(comparison.getDifferences(container), ReferenceChange.class)) {
                    EReference reference = diff.getReference();
                    EReference eOpposite = reference.getEOpposite();
                    EObject referenceChangeContainer = MatchUtil.getContainer(comparison, diff);
                    EObject value = referenceChange.getValue();
                    if (eOpposite == null || !eOpposite.equals(referenceChange.getReference()) || !value.equals(referenceChangeContainer)) continue;
                    equivalence.getDifferences().add((Object)diff);
                    break;
                }
                this.addChangesFromOrigin(comparison, referenceChange, equivalence);
            }
        }
    }

    private void addChangesFromOrigin(Comparison comparison, ReferenceChange diff, Equivalence equivalence) {
        EObject originContainer;
        if (!diff.getReference().isMany() && (originContainer = MatchUtil.getOriginContainer(comparison, diff)) != null) {
            for (Diff referenceChange : comparison.getDifferences(originContainer)) {
                if (!(referenceChange instanceof ReferenceChange) || !MatchUtil.getContainer(comparison, referenceChange).equals(originContainer.eGet((EStructuralFeature)diff.getReference(), false))) continue;
                equivalence.getDifferences().add((Object)referenceChange);
            }
        }
    }
}

