/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.spec;

import com.google.common.base.Objects;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.impl.AttributeChangeImpl;
import org.eclipse.emf.compare.utils.DiffUtil;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class AttributeChangeSpec
extends AttributeChangeImpl {
    public void copyLeftToRight() {
        if (this.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        if (this.getSource() == DifferenceSource.LEFT) {
            this.mergeRequires(false);
            switch (this.getKind()) {
                case ADD: {
                    this.addInTarget(false);
                    break;
                }
                case DELETE: {
                    this.removeFromTarget(false);
                    break;
                }
                case MOVE: {
                    this.moveElement(false);
                    break;
                }
                case CHANGE: {
                    if (this.isUnset()) {
                        this.removeFromTarget(false);
                        break;
                    }
                    this.addInTarget(false);
                    break;
                }
            }
        } else {
            this.mergeRequiredBy(false);
            switch (this.getKind()) {
                case ADD: {
                    this.removeFromTarget(false);
                    break;
                }
                case DELETE: {
                    this.addInTarget(false);
                    break;
                }
                case MOVE: {
                    this.moveElement(false);
                    break;
                }
                case CHANGE: {
                    if (this.isUnset()) {
                        this.addInTarget(false);
                        break;
                    }
                    this.resetInTarget(false);
                    break;
                }
            }
        }
        this.setState(DifferenceState.MERGED);
        if (this.getEquivalence() != null) {
            for (Diff equivalent : this.getEquivalence().getDifferences()) {
                equivalent.setState(DifferenceState.MERGED);
            }
        }
    }

    public void copyRightToLeft() {
        if (this.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        if (this.getSource() == DifferenceSource.LEFT) {
            this.mergeRequiredBy(true);
            switch (this.getKind()) {
                case ADD: {
                    this.removeFromTarget(true);
                    break;
                }
                case DELETE: {
                    this.addInTarget(true);
                    break;
                }
                case MOVE: {
                    this.moveElement(true);
                    break;
                }
                case CHANGE: {
                    if (this.isUnset()) {
                        this.addInTarget(true);
                        break;
                    }
                    this.resetInTarget(true);
                    break;
                }
            }
        } else {
            this.mergeRequires(true);
            switch (this.getKind()) {
                case ADD: {
                    this.addInTarget(true);
                    break;
                }
                case DELETE: {
                    this.removeFromTarget(true);
                    break;
                }
                case MOVE: {
                    this.moveElement(true);
                    break;
                }
                case CHANGE: {
                    if (this.isUnset()) {
                        this.removeFromTarget(true);
                        break;
                    }
                    this.addInTarget(true);
                    break;
                }
            }
        }
        this.setState(DifferenceState.MERGED);
        if (this.getEquivalence() != null) {
            for (Diff equivalent : this.getEquivalence().getDifferences()) {
                equivalent.setState(DifferenceState.MERGED);
            }
        }
    }

    public void discard() {
        this.setState(DifferenceState.DISCARDED);
    }

    protected boolean isUnset() {
        EObject expectedContainer = this.getSource() == DifferenceSource.LEFT ? this.getMatch().getLeft() : this.getMatch().getRight();
        Object currentValue = expectedContainer.eGet((EStructuralFeature)this.getAttribute());
        Object defaultValue = this.getAttribute().getDefaultValue();
        return currentValue == null || currentValue.equals(defaultValue) || defaultValue == null && "".equals(currentValue);
    }

    protected void mergeRequiredBy(boolean rightToLeft) {
        for (Diff dependency : this.getRequiredBy()) {
            if (rightToLeft) {
                dependency.copyRightToLeft();
                continue;
            }
            dependency.copyLeftToRight();
        }
    }

    protected void mergeRequires(boolean rightToLeft) {
        for (Diff dependency : this.getRequires()) {
            if (rightToLeft) {
                dependency.copyRightToLeft();
                continue;
            }
            dependency.copyLeftToRight();
        }
    }

    protected void addInTarget(boolean rightToLeft) {
        EObject expectedContainer = rightToLeft ? this.getMatch().getLeft() : this.getMatch().getRight();
        if (expectedContainer != null) {
            Comparison comparison = this.getMatch().getComparison();
            Object expectedValue = this.getValue();
            if (this.getAttribute().isMany()) {
                int insertionIndex = DiffUtil.findInsertionIndex(comparison, this, rightToLeft);
                List targetList = (List)expectedContainer.eGet((EStructuralFeature)this.getAttribute());
                if (targetList instanceof InternalEList) {
                    ((InternalEList)targetList).addUnique(insertionIndex, expectedValue);
                } else {
                    targetList.add(insertionIndex, expectedValue);
                }
            } else {
                expectedContainer.eSet((EStructuralFeature)this.getAttribute(), expectedValue);
            }
        }
    }

    protected void removeFromTarget(boolean rightToLeft) {
        EObject currentContainer = rightToLeft ? this.getMatch().getLeft() : this.getMatch().getRight();
        if (currentContainer != null) {
            Object expectedValue = this.getValue();
            if (this.getAttribute().isMany()) {
                List targetList = (List)currentContainer.eGet((EStructuralFeature)this.getAttribute());
                targetList.remove(expectedValue);
            } else {
                currentContainer.eUnset((EStructuralFeature)this.getAttribute());
            }
        }
    }

    protected void moveElement(boolean rightToLeft) {
        EObject expectedContainer = rightToLeft ? this.getMatch().getLeft() : this.getMatch().getRight();
        if (expectedContainer != null) {
            Comparison comparison = this.getMatch().getComparison();
            Object expectedValue = this.getValue();
            this.doMove(comparison, expectedContainer, expectedValue, rightToLeft);
        }
    }

    protected void doMove(Comparison comparison, EObject expectedContainer, Object expectedValue, boolean rightToLeft) {
        if (this.getAttribute().isMany()) {
            List targetList;
            int insertionIndex = DiffUtil.findInsertionIndex(comparison, this, rightToLeft);
            if (insertionIndex > (targetList = (List)expectedContainer.eGet((EStructuralFeature)this.getAttribute())).indexOf(expectedValue)) {
                --insertionIndex;
            }
            if (targetList instanceof EList) {
                ((EList)targetList).move(insertionIndex, expectedValue);
            } else {
                targetList.remove(expectedValue);
                targetList.add(insertionIndex, expectedValue);
            }
        } else {
            expectedContainer.eSet((EStructuralFeature)this.getAttribute(), expectedValue);
        }
    }

    protected void resetInTarget(boolean rightToLeft) {
        EObject targetContainer = rightToLeft ? this.getMatch().getLeft() : this.getMatch().getRight();
        EObject originContainer = this.getMatch().getComparison().isThreeWay() ? this.getMatch().getOrigin() : (rightToLeft ? this.getMatch().getRight() : this.getMatch().getLeft());
        if (originContainer == null || !targetContainer.eIsSet((EStructuralFeature)this.getAttribute()) || !originContainer.eIsSet((EStructuralFeature)this.getAttribute())) {
            targetContainer.eUnset((EStructuralFeature)this.getAttribute());
        } else {
            Object expectedValue = originContainer.eGet((EStructuralFeature)this.getAttribute());
            targetContainer.eSet((EStructuralFeature)this.getAttribute(), expectedValue);
        }
    }

    public String toString() {
        EDataType eAttributeType = this.getAttribute().getEAttributeType();
        String valueString = !FeatureMapUtil.isFeatureMap((EStructuralFeature)this.getAttribute()) ? EcoreUtil.convertToString((EDataType)eAttributeType, (Object)this.getValue()) : this.getValue().toString();
        return Objects.toStringHelper((Object)this).add("attribute", (Object)(String.valueOf(this.getAttribute().getEContainingClass().getName()) + "." + this.getAttribute().getName())).add("value", (Object)valueString).add("kind", (Object)this.getKind()).add("source", (Object)this.getSource()).add("state", (Object)this.getState()).toString();
    }
}

