/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.spec;

import com.google.common.base.Objects;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.impl.ReferenceChangeImpl;
import org.eclipse.emf.compare.internal.spec.EObjectUtil;
import org.eclipse.emf.compare.utils.DiffUtil;
import org.eclipse.emf.compare.utils.EMFCompareCopier;
import org.eclipse.emf.compare.utils.EqualityHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMIResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceChangeSpec
extends ReferenceChangeImpl {
    @Override
    public void copyLeftToRight() {
        if (this.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        if (this.getSource() == DifferenceSource.LEFT) {
            this.mergeRequires(false);
            switch (this.getKind()) {
                case ADD: {
                    this.addInTarget(false);
                    break;
                }
                case DELETE: {
                    this.removeFromTarget(false);
                    break;
                }
                case MOVE: {
                    this.moveElement(false);
                    break;
                }
                case CHANGE: {
                    if (this.getMatch().getLeft() != null) {
                        EObject leftValue = (EObject)this.getMatch().getLeft().eGet((EStructuralFeature)this.getReference(), false);
                        if (leftValue == null) {
                            this.removeFromTarget(false);
                            break;
                        }
                        this.addInTarget(false);
                        break;
                    }
                    this.removeFromTarget(false);
                    break;
                }
            }
        } else {
            this.mergeRequiredBy(false);
            switch (this.getKind()) {
                case ADD: {
                    this.removeFromTarget(false);
                    break;
                }
                case DELETE: {
                    this.addInTarget(false);
                    break;
                }
                case MOVE: {
                    this.moveElement(false);
                    break;
                }
                case CHANGE: {
                    if (this.getMatch().getRight() != null) {
                        EObject rightValue = (EObject)this.getMatch().getRight().eGet((EStructuralFeature)this.getReference(), false);
                        if (rightValue == null) {
                            this.addInTarget(false);
                            break;
                        }
                        this.resetInTarget(false);
                        break;
                    }
                    this.addInTarget(false);
                    break;
                }
            }
        }
        this.setState(DifferenceState.MERGED);
        if (this.getEquivalence() != null) {
            for (Diff equivalent : this.getEquivalence().getDifferences()) {
                equivalent.setState(DifferenceState.MERGED);
            }
        }
    }

    @Override
    public void copyRightToLeft() {
        if (this.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        if (this.getSource() == DifferenceSource.LEFT) {
            this.mergeRequiredBy(true);
            switch (this.getKind()) {
                case ADD: {
                    this.removeFromTarget(true);
                    break;
                }
                case DELETE: {
                    this.addInTarget(true);
                    break;
                }
                case MOVE: {
                    this.moveElement(true);
                    break;
                }
                case CHANGE: {
                    if (this.getMatch().getLeft() != null) {
                        EObject leftValue = (EObject)this.getMatch().getLeft().eGet((EStructuralFeature)this.getReference(), false);
                        if (leftValue == null) {
                            this.addInTarget(true);
                            break;
                        }
                        this.resetInTarget(true);
                        break;
                    }
                    this.addInTarget(true);
                    break;
                }
            }
        } else {
            this.mergeRequires(true);
            switch (this.getKind()) {
                case ADD: {
                    this.addInTarget(true);
                    break;
                }
                case DELETE: {
                    this.removeFromTarget(true);
                    break;
                }
                case MOVE: {
                    this.moveElement(true);
                    break;
                }
                case CHANGE: {
                    if (this.getMatch().getRight() != null) {
                        EObject rightValue = (EObject)this.getMatch().getRight().eGet((EStructuralFeature)this.getReference(), false);
                        if (rightValue == null) {
                            this.removeFromTarget(true);
                            break;
                        }
                        this.addInTarget(true);
                        break;
                    }
                    this.removeFromTarget(true);
                    break;
                }
            }
        }
        this.setState(DifferenceState.MERGED);
        if (this.getEquivalence() != null) {
            for (Diff equivalent : this.getEquivalence().getDifferences()) {
                equivalent.setState(DifferenceState.MERGED);
            }
        }
    }

    @Override
    public void discard() {
        this.setState(DifferenceState.DISCARDED);
    }

    protected void mergeRequiredBy(boolean rightToLeft) {
        for (Diff dependency : this.getRequiredBy()) {
            if (dependency.getState() == DifferenceState.MERGED) continue;
            if (rightToLeft) {
                dependency.copyRightToLeft();
                continue;
            }
            dependency.copyLeftToRight();
        }
    }

    protected void mergeRequires(boolean rightToLeft) {
        for (Diff dependency : this.getRequires()) {
            if (dependency.getState() == DifferenceState.MERGED) continue;
            if (rightToLeft) {
                dependency.copyRightToLeft();
                continue;
            }
            dependency.copyLeftToRight();
        }
    }

    protected void moveElement(boolean rightToLeft) {
        EObject expectedValue;
        EObject expectedContainer = rightToLeft ? this.getMatch().getLeft() : this.getMatch().getRight();
        Comparison comparison = this.getMatch().getComparison();
        Match valueMatch = comparison.getMatch(this.getValue());
        if (expectedContainer == null) {
            return;
        }
        if (valueMatch == null) {
            if (this.getReference().isMany()) {
                List targetList = (List)expectedContainer.eGet((EStructuralFeature)this.getReference());
                expectedValue = this.findMatchIn(targetList, this.getValue());
            } else {
                expectedValue = (EObject)expectedContainer.eGet((EStructuralFeature)this.getReference());
            }
        } else {
            expectedValue = rightToLeft ? valueMatch.getLeft() : valueMatch.getRight();
        }
        this.doMove(comparison, expectedContainer, expectedValue, rightToLeft);
    }

    protected void doMove(Comparison comparison, EObject expectedContainer, EObject expectedValue, boolean rightToLeft) {
        if (this.getReference().isMany()) {
            List targetList;
            int insertionIndex = DiffUtil.findInsertionIndex(comparison, this, rightToLeft);
            if (insertionIndex > (targetList = (List)expectedContainer.eGet((EStructuralFeature)this.getReference())).indexOf(expectedValue)) {
                --insertionIndex;
            }
            if (targetList instanceof EList) {
                ((EList)targetList).move(insertionIndex, (Object)expectedValue);
            } else {
                targetList.remove(expectedValue);
                targetList.add(insertionIndex, expectedValue);
            }
        } else {
            expectedContainer.eSet((EStructuralFeature)this.getReference(), (Object)expectedValue);
        }
    }

    protected void addInTarget(boolean rightToLeft) {
        EObject expectedValue;
        EObject expectedContainer = rightToLeft ? this.getMatch().getLeft() : this.getMatch().getRight();
        Comparison comparison = this.getMatch().getComparison();
        if (expectedContainer == null) {
            return;
        }
        Match valueMatch = comparison.getMatch(this.getValue());
        if (valueMatch == null) {
            expectedValue = this.getValue().eIsProxy() ? EcoreUtil.copy((EObject)this.getValue()) : this.getValue();
        } else if (rightToLeft) {
            if (this.getReference().isContainment()) {
                expectedValue = this.createTarget(this.getValue());
                valueMatch.setLeft(expectedValue);
            } else {
                expectedValue = valueMatch.getLeft();
            }
        } else if (this.getReference().isContainment()) {
            expectedValue = this.createTarget(this.getValue());
            valueMatch.setRight(expectedValue);
        } else {
            expectedValue = valueMatch.getRight();
        }
        if (this.getReference().isMany()) {
            int insertionIndex = DiffUtil.findInsertionIndex(comparison, this, rightToLeft);
            List targetList = (List)expectedContainer.eGet((EStructuralFeature)this.getReference());
            if (targetList instanceof InternalEList) {
                ((InternalEList)targetList).addUnique(insertionIndex, (Object)expectedValue);
            } else {
                targetList.add(insertionIndex, expectedValue);
            }
        } else {
            expectedContainer.eSet((EStructuralFeature)this.getReference(), (Object)expectedValue);
        }
        if (this.getReference().isContainment()) {
            Resource initialResource = this.getValue().eResource();
            Resource targetResource = expectedValue.eResource();
            if (initialResource instanceof XMIResource && targetResource instanceof XMIResource) {
                ((XMIResource)targetResource).setID(expectedValue, ((XMIResource)initialResource).getID(this.getValue()));
            }
        }
    }

    protected EObject createTarget(EObject referenceObject) {
        EMFCompareCopier copier = new EMFCompareCopier();
        return copier.copy(referenceObject);
    }

    protected void removeFromTarget(boolean rightToLeft) {
        EObject expectedValue;
        List targetList;
        EObject currentContainer = rightToLeft ? this.getMatch().getLeft() : this.getMatch().getRight();
        Comparison comparison = this.getMatch().getComparison();
        Match valueMatch = comparison.getMatch(this.getValue());
        if (currentContainer == null) {
            return;
        }
        if (valueMatch == null) {
            if (this.getReference().isMany()) {
                targetList = (List)currentContainer.eGet((EStructuralFeature)this.getReference());
                expectedValue = this.findMatchIn(targetList, this.getValue());
            } else {
                expectedValue = null;
            }
        } else {
            expectedValue = rightToLeft ? valueMatch.getLeft() : valueMatch.getRight();
        }
        if (this.getReference().isContainment() && expectedValue != null) {
            EcoreUtil.remove((EObject)expectedValue);
            if (rightToLeft && valueMatch != null) {
                valueMatch.setLeft(null);
            } else if (valueMatch != null) {
                valueMatch.setRight(null);
            }
        } else if (this.getReference().isMany()) {
            targetList = (List)currentContainer.eGet((EStructuralFeature)this.getReference());
            targetList.remove(expectedValue);
        } else {
            currentContainer.eUnset((EStructuralFeature)this.getReference());
        }
    }

    protected void resetInTarget(boolean rightToLeft) {
        EObject targetContainer = rightToLeft ? this.getMatch().getLeft() : this.getMatch().getRight();
        EObject originContainer = this.getMatch().getComparison().isThreeWay() ? this.getMatch().getOrigin() : (rightToLeft ? this.getMatch().getRight() : this.getMatch().getLeft());
        if (originContainer == null || !targetContainer.eIsSet((EStructuralFeature)this.getReference()) || !originContainer.eIsSet((EStructuralFeature)this.getReference())) {
            targetContainer.eUnset((EStructuralFeature)this.getReference());
        } else {
            EObject originalValue = (EObject)originContainer.eGet((EStructuralFeature)this.getReference());
            Match valueMatch = this.getMatch().getComparison().getMatch(originalValue);
            EObject expectedValue = valueMatch == null ? originalValue : (rightToLeft ? valueMatch.getLeft() : valueMatch.getRight());
            targetContainer.eSet((EStructuralFeature)this.getReference(), (Object)expectedValue);
        }
    }

    private EObject findMatchIn(List<EObject> list, EObject element) {
        Comparison comparison = this.getMatch().getComparison();
        EqualityHelper helper = comparison.getConfiguration().getEqualityHelper();
        for (EObject next : list) {
            if (!helper.matchingValues(comparison, next, element)) continue;
            return next;
        }
        return null;
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("reference", (Object)(String.valueOf(this.getReference().getEContainingClass().getName()) + "." + this.getReference().getName())).add("value", (Object)EObjectUtil.getLabel(this.getValue())).add("parentMatch", (Object)this.getMatch().toString()).add("match of value", (Object)this.getMatch().getComparison().getMatch(this.getValue())).add("kind", (Object)this.getKind()).add("source", (Object)this.getSource()).add("state", (Object)this.getState()).toString();
    }
}

