/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.eobject;

import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.eclipse.emf.compare.match.eobject.EObjectIndex;
import org.eclipse.emf.compare.match.eobject.ProximityEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.ProximityIndex;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ByTypeIndex
implements EObjectIndex {
    private Cache<EClass, EObjectIndex> allIndexes;
    private ProximityEObjectMatcher.DistanceFunction meter;

    public ByTypeIndex(ProximityEObjectMatcher.DistanceFunction meter) {
        this.meter = meter;
        this.allIndexes = CacheBuilder.newBuilder().build(CacheLoader.from((Function)new Function<EClass, EObjectIndex>(){

            public EObjectIndex apply(EClass input) {
                return new ProximityIndex(ByTypeIndex.this.meter);
            }
        }));
    }

    @Override
    public Collection<EObject> getValuesStillThere(EObjectIndex.Side side) {
        LinkedHashSet<EObject> values = new LinkedHashSet<EObject>();
        for (EObjectIndex typeSpecificIndex : this.allIndexes.asMap().values()) {
            values.addAll(typeSpecificIndex.getValuesStillThere(side));
        }
        return values;
    }

    @Override
    public Map<EObjectIndex.Side, EObject> findClosests(EObject obj, EObjectIndex.Side side, int maxDistance) {
        try {
            EObjectIndex typeSpecificIndex = (EObjectIndex)this.allIndexes.get((Object)obj.eClass());
            return typeSpecificIndex.findClosests(obj, side, maxDistance);
        }
        catch (ExecutionException executionException) {
            return Collections.emptyMap();
        }
    }

    @Override
    public void remove(EObject obj, EObjectIndex.Side side) {
        try {
            EObjectIndex typeSpecificIndex = (EObjectIndex)this.allIndexes.get((Object)obj.eClass());
            typeSpecificIndex.remove(obj, side);
        }
        catch (ExecutionException executionException) {}
    }

    @Override
    public void index(EObject eObjs, EObjectIndex.Side side) {
        try {
            EObjectIndex typeSpecificIndex = (EObjectIndex)this.allIndexes.get((Object)eObjs.eClass());
            typeSpecificIndex.index(eObjs, side);
        }
        catch (ExecutionException executionException) {}
    }
}

