/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.eobject;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.diff.DefaultDiffEngine;
import org.eclipse.emf.compare.diff.FeatureFilter;
import org.eclipse.emf.compare.diff.IDiffProcessor;
import org.eclipse.emf.compare.match.eobject.PairCharDistance;
import org.eclipse.emf.compare.match.eobject.ProximityEObjectMatcher;
import org.eclipse.emf.compare.utils.EqualityHelper;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EditionDistance
implements ProximityEObjectMatcher.DistanceFunction {
    private int referenceChangeCoef = 10;
    private int attributeChangeCoef = 20;
    private int locationChangeCoef = 1;
    private int orderChangeCoef = 5;
    private Map<EStructuralFeature, Integer> weights = Maps.newHashMap();
    private Set<EStructuralFeature> toBeIgnored;
    private EqualityHelper helper;

    public EditionDistance(EqualityHelper equalityHelper) {
        this.helper = equalityHelper;
        this.toBeIgnored = Sets.newLinkedHashSet();
    }

    public int distance(EObject a, EObject b, int maxDistance) {
        return new CountingDiffEngine(maxDistance).measureDifferences(a, b);
    }

    public static Builder builder(EqualityHelper helper) {
        return new Builder(helper);
    }

    public static class Builder {
        private EditionDistance toBeBuilt;

        public Builder(EqualityHelper toBe) {
            this.toBeBuilt = new EditionDistance(toBe);
        }

        public Builder weight(EStructuralFeature feat, Integer weight) {
            this.toBeBuilt.weights.put(feat, weight);
            return this;
        }

        public Builder ignore(EStructuralFeature featToIgnore) {
            this.toBeBuilt.toBeIgnored.add(featToIgnore);
            return this;
        }

        public Builder uri(int weight) {
            this.toBeBuilt.locationChangeCoef = weight;
            return this;
        }

        public Builder order(int weight) {
            this.toBeBuilt.orderChangeCoef = weight;
            return this;
        }

        public Builder attribute(int weight) {
            this.toBeBuilt.attributeChangeCoef = weight;
            return this;
        }

        public Builder reference(int weight) {
            this.toBeBuilt.referenceChangeCoef = weight;
            return this;
        }

        public EditionDistance build() {
            return this.toBeBuilt;
        }
    }

    class CountingDiffEngine
    extends DefaultDiffEngine {
        private Comparison fakeComparison;
        private int maxDistance;

        public CountingDiffEngine(int maxDistance) {
            super(new CountingDiffProcessor());
            this.maxDistance = maxDistance;
            this.fakeComparison = CompareFactory.eINSTANCE.createComparison();
            this.helper = EditionDistance.this.helper;
        }

        protected void computeDifferences(Match match, EAttribute attribute, boolean checkOrdering) {
            if (this.getCounter().getComputedDistance() <= this.maxDistance) {
                super.computeDifferences(match, attribute, checkOrdering);
            }
        }

        protected void computeDifferences(Match match, EReference reference, boolean checkOrdering) {
            if (this.getCounter().getComputedDistance() <= this.maxDistance) {
                super.computeDifferences(match, reference, checkOrdering);
            }
        }

        public int measureDifferences(EObject a, EObject b) {
            Match fakeMatch = CompareFactory.eINSTANCE.createMatch();
            fakeMatch.setLeft(a);
            fakeMatch.setRight(b);
            URI aLocation = this.helper.getURI(a);
            URI bLocation = this.helper.getURI(b);
            int changes = 0;
            if (!aLocation.fragment().equals(bLocation.fragment())) {
                int dist = new PairCharDistance().distance(aLocation.fragment(), bLocation.fragment());
                changes += dist * EditionDistance.this.locationChangeCoef * 1;
            }
            if (changes <= this.maxDistance) {
                this.checkForDifferences(fakeMatch);
                changes += this.getCounter().getComputedDistance();
            }
            return changes;
        }

        protected CountingDiffProcessor getCounter() {
            return (CountingDiffProcessor)this.getDiffProcessor();
        }

        protected Comparison getComparison() {
            return this.fakeComparison;
        }

        protected FeatureFilter createFeatureFilter() {
            return new FeatureFilter(){

                @Override
                public Iterator<EReference> getReferencesToCheck(Match match) {
                    return Iterators.filter(super.getReferencesToCheck(match), (Predicate)new Predicate<EReference>(){

                        public boolean apply(EReference input) {
                            return EditionDistance.this.toBeIgnored.contains(input) && !input.isContainment();
                        }
                    });
                }

                @Override
                public Iterator<EAttribute> getAttributesToCheck(Match match) {
                    return Iterators.filter(super.getAttributesToCheck(match), (Predicate)new Predicate<EAttribute>(){

                        public boolean apply(EAttribute input) {
                            return !EditionDistance.this.toBeIgnored.contains(input);
                        }
                    });
                }
            };
        }
    }

    class CountingDiffProcessor
    implements IDiffProcessor {
        private int distance;
        private PairCharDistance stringMeter = new PairCharDistance();

        CountingDiffProcessor() {
        }

        public void referenceChange(Match match, EReference reference, EObject value, DifferenceKind kind, DifferenceSource source) {
            this.distance += this.getWeight((EStructuralFeature)reference) * EditionDistance.this.referenceChangeCoef;
        }

        public void attributeChange(Match match, EAttribute attribute, Object value, DifferenceKind kind, DifferenceSource source) {
            Object aValue = match.getLeft().eGet((EStructuralFeature)attribute);
            Object bValue = match.getRight().eGet((EStructuralFeature)attribute);
            switch (kind) {
                case MOVE: {
                    this.distance += this.getWeight((EStructuralFeature)attribute) * EditionDistance.this.orderChangeCoef;
                    break;
                }
                case ADD: 
                case DELETE: 
                case CHANGE: {
                    if (aValue instanceof String && bValue instanceof String) {
                        this.distance += this.getWeight((EStructuralFeature)attribute) * this.stringMeter.distance((String)aValue, (String)bValue);
                        break;
                    }
                    this.distance += this.getWeight((EStructuralFeature)attribute) * EditionDistance.this.attributeChangeCoef;
                    break;
                }
            }
        }

        private int getWeight(EStructuralFeature attribute) {
            Integer found = (Integer)EditionDistance.this.weights.get(attribute);
            if (found == null) {
                found = 1;
            }
            return found;
        }

        public int getComputedDistance() {
            return this.distance;
        }
    }
}

