/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.eobject;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.match.eobject.IEObjectMatcher;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentifierEObjectMatcher
implements IEObjectMatcher {
    private Optional<IEObjectMatcher> delegate = Optional.absent();
    private Function<EObject, String> idComputation = new DefaultIDFunction();

    public IdentifierEObjectMatcher() {
        this.delegate = Optional.absent();
    }

    public IdentifierEObjectMatcher(IEObjectMatcher delegateWhenNoID) {
        this.delegate = Optional.of((Object)delegateWhenNoID);
    }

    @Override
    public Iterable<Match> createMatches(Iterator<? extends EObject> leftEObjects, Iterator<? extends EObject> rightEObjects, Iterator<? extends EObject> originEObjects) {
        ArrayList leftEObjectsNoID = Lists.newArrayList();
        ArrayList rightEObjectsNoID = Lists.newArrayList();
        ArrayList originEObjectsNoID = Lists.newArrayList();
        Set<Match> matches = this.matchPerId(leftEObjects, rightEObjects, originEObjects, leftEObjectsNoID, rightEObjectsNoID, originEObjectsNoID);
        if (this.delegate.isPresent()) {
            matches.addAll(Lists.newArrayList(((IEObjectMatcher)this.delegate.get()).createMatches(leftEObjectsNoID.iterator(), rightEObjectsNoID.iterator(), originEObjectsNoID.iterator())));
        } else {
            Match match;
            for (EObject eObject : leftEObjectsNoID) {
                match = CompareFactory.eINSTANCE.createMatch();
                match.setLeft(eObject);
                matches.add(match);
            }
            for (EObject eObject : rightEObjectsNoID) {
                match = CompareFactory.eINSTANCE.createMatch();
                match.setRight(eObject);
                matches.add(match);
            }
            for (EObject eObject : originEObjectsNoID) {
                match = CompareFactory.eINSTANCE.createMatch();
                match.setOrigin(eObject);
                matches.add(match);
            }
        }
        return matches;
    }

    protected Set<Match> matchPerId(Iterator<? extends EObject> leftEObjects, Iterator<? extends EObject> rightEObjects, Iterator<? extends EObject> originEObjects, List<EObject> leftEObjectsNoID, List<EObject> rightEObjectsNoID, List<EObject> originEObjectsNoID) {
        Match parent;
        EObject parentEObject;
        Match match;
        String identifier;
        LinkedHashSet matches = Sets.newLinkedHashSet();
        HashMap idToMatch = Maps.newHashMap();
        HashMap leftEObjectsToMatch = Maps.newHashMap();
        HashMap rightEObjectsToMatch = Maps.newHashMap();
        HashMap originEObjectsToMatch = Maps.newHashMap();
        while (leftEObjects.hasNext()) {
            EObject left = leftEObjects.next();
            identifier = (String)this.idComputation.apply((Object)left);
            if (identifier != null) {
                match = CompareFactory.eINSTANCE.createMatch();
                match.setLeft(left);
                parentEObject = left.eContainer();
                parent = (Match)leftEObjectsToMatch.get(parentEObject);
                if (parent != null) {
                    parent.getSubmatches().add((Object)match);
                } else {
                    matches.add(match);
                }
                idToMatch.put(identifier, match);
                leftEObjectsToMatch.put(left, match);
                continue;
            }
            leftEObjectsNoID.add(left);
        }
        while (rightEObjects.hasNext()) {
            EObject right = rightEObjects.next();
            identifier = (String)this.idComputation.apply((Object)right);
            if (identifier != null) {
                match = (Match)idToMatch.get(identifier);
                if (match != null) {
                    match.setRight(right);
                    rightEObjectsToMatch.put(right, match);
                    continue;
                }
                match = CompareFactory.eINSTANCE.createMatch();
                match.setRight(right);
                parentEObject = right.eContainer();
                parent = (Match)rightEObjectsToMatch.get(parentEObject);
                if (parent != null) {
                    parent.getSubmatches().add((Object)match);
                } else {
                    matches.add(match);
                }
                rightEObjectsToMatch.put(right, match);
                idToMatch.put(identifier, match);
                continue;
            }
            rightEObjectsNoID.add(right);
        }
        while (originEObjects.hasNext()) {
            EObject origin = originEObjects.next();
            identifier = (String)this.idComputation.apply((Object)origin);
            if (identifier != null) {
                match = (Match)idToMatch.get(identifier);
                if (match != null) {
                    match.setOrigin(origin);
                    originEObjectsToMatch.put(origin, match);
                    continue;
                }
                match = CompareFactory.eINSTANCE.createMatch();
                match.setOrigin(origin);
                parentEObject = origin.eContainer();
                parent = (Match)originEObjectsToMatch.get(parentEObject);
                if (parent != null) {
                    parent.getSubmatches().add((Object)match);
                } else {
                    matches.add(match);
                }
                idToMatch.put(identifier, match);
                originEObjectsToMatch.put(origin, match);
                continue;
            }
            originEObjectsNoID.add(origin);
        }
        return matches;
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private IdentifierEObjectMatcher toBe = new IdentifierEObjectMatcher();

        public Builder idFunction(Function<EObject, String> idFunction) {
            this.toBe.idComputation = idFunction;
            return this;
        }

        public Builder delegateWhenNoId(IEObjectMatcher delegateWhenNoID) {
            this.toBe.delegate = Optional.of((Object)delegateWhenNoID);
            return this;
        }

        public IdentifierEObjectMatcher build() {
            return this.toBe;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultIDFunction
    implements Function<EObject, String> {
        public String apply(EObject eObject) {
            Resource eObjectResource;
            String functionalId;
            String identifier = eObject == null ? null : (eObject.eIsProxy() ? ((InternalEObject)eObject).eProxyURI().fragment() : ((functionalId = EcoreUtil.getID((EObject)eObject)) != null ? functionalId : ((eObjectResource = eObject.eResource()) instanceof XMIResource ? ((XMIResource)eObjectResource).getID(eObject) : null)));
            return identifier;
        }
    }
}

