/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.eobject;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.match.eobject.ByTypeIndex;
import org.eclipse.emf.compare.match.eobject.EObjectIndex;
import org.eclipse.emf.compare.match.eobject.IEObjectMatcher;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProximityEObjectMatcher
implements IEObjectMatcher {
    private static final int DEFAULT_DISTANCE = 500;
    private EObjectIndex index;
    private int maxDistanceForMatching = 500;
    private List<Match> matches = Lists.newArrayList();
    private Map<EObject, Match> eObjectsToMatch = Maps.newHashMap();

    public ProximityEObjectMatcher(DistanceFunction meter) {
        this.index = new ByTypeIndex(meter);
    }

    @Override
    public Iterable<Match> createMatches(Iterator<? extends EObject> leftEObjects, Iterator<? extends EObject> rightEObjects, Iterator<? extends EObject> originEObjects) {
        Map<EObjectIndex.Side, EObject> closests;
        while (leftEObjects.hasNext() || rightEObjects.hasNext() || leftEObjects.hasNext()) {
            if (leftEObjects.hasNext()) {
                this.index.index(leftEObjects.next(), EObjectIndex.Side.LEFT);
            }
            if (rightEObjects.hasNext()) {
                this.index.index(rightEObjects.next(), EObjectIndex.Side.RIGHT);
            }
            if (!originEObjects.hasNext()) continue;
            this.index.index(originEObjects.next(), EObjectIndex.Side.ORIGIN);
        }
        for (EObject left : this.index.getValuesStillThere(EObjectIndex.Side.LEFT)) {
            closests = this.index.findClosests(left, EObjectIndex.Side.LEFT, this.maxDistanceForMatching);
            EObject right = closests.get((Object)EObjectIndex.Side.RIGHT);
            EObject ancestor = closests.get((Object)EObjectIndex.Side.ORIGIN);
            this.areMatching(left, right, ancestor);
            if (right != null) {
                this.index.remove(right, EObjectIndex.Side.RIGHT);
            }
            if (left != null) {
                this.index.remove(left, EObjectIndex.Side.LEFT);
            }
            if (ancestor == null) continue;
            this.index.remove(ancestor, EObjectIndex.Side.ORIGIN);
        }
        for (EObject rObj : this.index.getValuesStillThere(EObjectIndex.Side.RIGHT)) {
            closests = this.index.findClosests(rObj, EObjectIndex.Side.RIGHT, this.maxDistanceForMatching);
            EObject lObj = closests.get((Object)EObjectIndex.Side.LEFT);
            EObject aObj = closests.get((Object)EObjectIndex.Side.ORIGIN);
            this.areMatching(lObj, rObj, aObj);
            if (rObj != null) {
                this.index.remove(rObj, EObjectIndex.Side.RIGHT);
            }
            if (lObj != null) {
                this.index.remove(lObj, EObjectIndex.Side.LEFT);
            }
            if (aObj == null) continue;
            this.index.remove(aObj, EObjectIndex.Side.ORIGIN);
        }
        for (EObject notFound : this.index.getValuesStillThere(EObjectIndex.Side.RIGHT)) {
            this.areMatching(null, notFound, null);
            this.index.remove(notFound, EObjectIndex.Side.RIGHT);
        }
        for (EObject notFound : this.index.getValuesStillThere(EObjectIndex.Side.LEFT)) {
            this.areMatching(notFound, null, null);
            this.index.remove(notFound, EObjectIndex.Side.LEFT);
        }
        for (EObject notFound : this.index.getValuesStillThere(EObjectIndex.Side.ORIGIN)) {
            this.areMatching(null, null, notFound);
            this.index.remove(notFound, EObjectIndex.Side.ORIGIN);
        }
        this.restructureMatchModel();
        return this.matches;
    }

    private void restructureMatchModel() {
        Iterator<Match> it = this.matches.iterator();
        while (it.hasNext()) {
            Match possibleContainerMatch;
            Match cur = it.next();
            EObject possibleContainer = null;
            if (cur.getLeft() != null) {
                possibleContainer = cur.getLeft().eContainer();
            }
            if (possibleContainer != null && cur.getRight() != null) {
                possibleContainer = cur.getRight().eContainer();
            }
            if (possibleContainer != null && cur.getOrigin() != null) {
                possibleContainer = cur.getOrigin().eContainer();
            }
            if ((possibleContainerMatch = this.eObjectsToMatch.get(possibleContainer)) == null) continue;
            ((BasicEList)possibleContainerMatch.getSubmatches()).addUnique((Object)cur);
            it.remove();
        }
        Iterator<Match> it2 = this.matches.iterator();
        if (it2.hasNext()) {
            Match root = it2.next();
            while (it2.hasNext()) {
                ((BasicEList)root.getSubmatches()).addUnique((Object)it2.next());
                it2.remove();
            }
        }
    }

    private Match areMatching(EObject left, EObject right, EObject origin) {
        Match result = CompareFactory.eINSTANCE.createMatch();
        result.setLeft(left);
        result.setRight(right);
        result.setOrigin(origin);
        this.matches.add(result);
        if (left != null) {
            this.eObjectsToMatch.put(left, result);
            this.index.remove(left, EObjectIndex.Side.LEFT);
        }
        if (right != null) {
            this.eObjectsToMatch.put(right, result);
            this.index.remove(right, EObjectIndex.Side.RIGHT);
        }
        if (origin != null) {
            this.eObjectsToMatch.put(origin, result);
            this.index.remove(origin, EObjectIndex.Side.ORIGIN);
        }
        return result;
    }

    public static Builder builder(DistanceFunction function) {
        return new Builder(function);
    }

    public static class Builder {
        private ProximityEObjectMatcher beingConfigured;

        public Builder(DistanceFunction function) {
            this.beingConfigured = new ProximityEObjectMatcher(function);
        }

        public Builder maxDistance(int max) {
            this.beingConfigured.maxDistanceForMatching = max;
            return this;
        }

        public Builder distanceFunction(DistanceFunction function) {
            this.beingConfigured.index = new ByTypeIndex(function);
            return this;
        }

        public ProximityEObjectMatcher build() {
            return this.beingConfigured;
        }
    }

    public static interface DistanceFunction {
        public int distance(EObject var1, EObject var2, int var3);
    }
}

