/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.utils;

import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class MatchUtil {
    private MatchUtil() {
    }

    public static EObject getOriginObject(Comparison comparison, EObject object) {
        EObject result = null;
        Match match = comparison.getMatch(object);
        if (match != null) {
            result = comparison.isThreeWay() ? match.getOrigin() : (object == match.getLeft() ? match.getRight() : match.getLeft());
        }
        return result;
    }

    public static EObject getOriginValue(Comparison comparison, ReferenceChange difference) {
        Object originValue;
        EObject originContainer;
        if (!difference.getReference().isContainment() && !difference.getReference().isMany() && difference.getKind().equals((Object)DifferenceKind.CHANGE) && (originContainer = MatchUtil.getOriginContainer(comparison, difference)) != null && (originValue = originContainer.eGet((EStructuralFeature)difference.getReference())) instanceof EObject) {
            return (EObject)originValue;
        }
        return null;
    }

    public static EObject getOriginContainer(Comparison comparison, ReferenceChange difference) {
        EObject diffContainer = comparison.isThreeWay() ? difference.getMatch().getOrigin() : (MatchUtil.getContainer(comparison, difference) == difference.getMatch().getLeft() ? difference.getMatch().getRight() : difference.getMatch().getLeft());
        return diffContainer;
    }

    public static EObject getContainer(Comparison comparison, ReferenceChange difference) {
        EObject result = null;
        EObject value = difference.getValue();
        Match match = difference.getMatch();
        if (ReferenceUtil.getAsList(match.getLeft(), (EStructuralFeature)difference.getReference()).contains(value)) {
            result = match.getLeft();
        } else if (ReferenceUtil.getAsList(match.getRight(), (EStructuralFeature)difference.getReference()).contains(value)) {
            result = match.getRight();
        } else if (ReferenceUtil.getAsList(match.getOrigin(), (EStructuralFeature)difference.getReference()).contains(value)) {
            result = match.getOrigin();
        }
        return result;
    }

    public static EObject getContainer(AttributeChange difference) {
        EObject result = difference.getMatch().getLeft();
        if (result == null) {
            result = difference.getMatch().getRight();
        }
        if (result == null) {
            result = difference.getMatch().getOrigin();
        }
        return result;
    }

    public static EObject getContainer(Comparison comparison, Diff difference) {
        EObject result = null;
        if (difference instanceof AttributeChange) {
            result = MatchUtil.getContainer((AttributeChange)difference);
        } else if (difference instanceof ReferenceChange) {
            result = MatchUtil.getContainer(comparison, (ReferenceChange)difference);
        }
        return result;
    }
}

