/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.utils;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReferenceUtil {
    private ReferenceUtil() {
    }

    public static List<EStructuralFeature> getCopiableReferences(EObject eObject) {
        EClass eClass = eObject.eClass();
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        int j = 0;
        while (j < eClass.getFeatureCount()) {
            EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(j);
            if (eStructuralFeature.isChangeable() && !eStructuralFeature.isDerived() && (ReferenceUtil.isSimpleReference(eStructuralFeature) || ReferenceUtil.isFeatureMap(eStructuralFeature))) {
                result.add(eStructuralFeature);
            }
            ++j;
        }
        return result;
    }

    public static boolean isSimpleReference(EStructuralFeature feature) {
        return feature instanceof EReference && !((EReference)feature).isContainment() && !((EReference)feature).isContainer();
    }

    public static boolean isFeatureMap(EStructuralFeature feature) {
        return FeatureMapUtil.isFeatureMap((EStructuralFeature)feature);
    }

    private static Set<EObject> getReferencedEObject(EObject eObject, EStructuralFeature feature, boolean resolveProxies) {
        LinkedHashSet<EObject> result;
        block8: {
            block6: {
                Object obj;
                block7: {
                    result = new LinkedHashSet<EObject>();
                    if (!ReferenceUtil.isSimpleReference(feature)) break block6;
                    obj = eObject.eGet(feature, resolveProxies);
                    if (!(obj instanceof EObject)) break block7;
                    result.add((EObject)obj);
                    break block8;
                }
                if (!(obj instanceof Collection)) break block8;
                result.addAll((Collection)obj);
                break block8;
            }
            if (ReferenceUtil.isFeatureMap(feature)) {
                FeatureMap featureMap = (FeatureMap)eObject.eGet(feature);
                int k = 0;
                while (k < featureMap.size()) {
                    EStructuralFeature f = featureMap.getEStructuralFeature(k);
                    if (f instanceof EReference) {
                        Object referencedEObject = featureMap.getValue(k);
                        if (referencedEObject instanceof EObject) {
                            result.add((EObject)referencedEObject);
                        } else if (referencedEObject instanceof Collection) {
                            result.addAll((Collection)referencedEObject);
                        }
                    }
                    ++k;
                }
            }
        }
        return result;
    }

    public static Set<EObject> getReferencedEObjects(EObject eObject, boolean resolveProxies) {
        LinkedHashSet<EObject> result = new LinkedHashSet<EObject>();
        for (EStructuralFeature feature : ReferenceUtil.getCopiableReferences(eObject)) {
            result.addAll(ReferenceUtil.getReferencedEObject(eObject, feature, resolveProxies));
        }
        return result;
    }

    public static List<Object> getAsList(EObject object, EStructuralFeature feature) {
        if (object != null) {
            Object value = object.eGet(feature, false);
            Object asList = value instanceof InternalEList ? ((InternalEList)value).basicList() : (value instanceof List ? (List)value : (value instanceof Iterable ? ImmutableList.copyOf((Iterable)((Iterable)value)) : (value != null ? ImmutableList.of((Object)value) : Collections.emptyList())));
            return asList;
        }
        return Collections.emptyList();
    }
}

