/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider.spec;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.provider.MatchItemProvider;
import org.eclipse.emf.compare.provider.spec.CompareItemProviderAdapterFactorySpec;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchItemProviderSpec
extends MatchItemProvider {
    private static final Predicate<ReferenceChange> CONTAINMENT_REFERENCE_CHANGE = new Predicate<ReferenceChange>(){

        public boolean apply(ReferenceChange input) {
            return input.getReference().isContainment();
        }
    };
    private static final Function<ReferenceChange, EObject> VALUE = new Function<ReferenceChange, EObject>(){

        public EObject apply(ReferenceChange input) {
            return input.getValue();
        }
    };
    static final Predicate<? super Object> REFINED_OR_REQUIRED_BY_REFINED_DIFF = new Predicate<Object>(){

        public boolean apply(Object input) {
            boolean ret = false;
            if (input instanceof Diff) {
                Diff diff = (Diff)input;
                if (diff.getRefines().isEmpty()) {
                    for (Diff requiredBy : diff.getRequiredBy()) {
                        if (requiredBy.getRefines().isEmpty()) continue;
                        ret = true;
                        break;
                    }
                } else {
                    ret = true;
                }
            }
            return ret;
        }
    };
    private static final Predicate<? super Object> PSEUDO_CONFLICT_DIFF = new Predicate<Object>(){

        public boolean apply(Object input) {
            Diff diff;
            Conflict conflict;
            boolean ret = false;
            if (input instanceof Diff && (conflict = (diff = (Diff)input).getConflict()) != null && conflict.getKind() == ConflictKind.PSEUDO) {
                ret = true;
            }
            return ret;
        }
    };
    private static final Predicate<? super Object> PSEUDO_DELETE_CONFLICT = new Predicate<Object>(){

        public boolean apply(Object input) {
            ReferenceChange referenceChange;
            Conflict conflict;
            boolean ret = false;
            if (input instanceof ReferenceChange && (conflict = (referenceChange = (ReferenceChange)input).getConflict()) != null) {
                EReference eReference = referenceChange.getReference();
                EObject value = referenceChange.getValue();
                Iterable conflictualReferenceChanges = Iterables.filter((Iterable)conflict.getDifferences(), ReferenceChange.class);
                for (ReferenceChange conflictualReferenceChange : conflictualReferenceChanges) {
                    if (conflictualReferenceChange == referenceChange || conflictualReferenceChange.getReference() != eReference || conflictualReferenceChange.getValue() != value) continue;
                    ret = true;
                }
            }
            return ret;
        }
    };

    public MatchItemProviderSpec(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public Object getImage(Object object) {
        Match match = (Match)object;
        Object ret = CompareItemProviderAdapterFactorySpec.getImage(this.getRootAdapterFactory(), match.getLeft());
        if (ret == null) {
            ret = CompareItemProviderAdapterFactorySpec.getImage(this.getRootAdapterFactory(), match.getRight());
        }
        if (ret == null) {
            ret = CompareItemProviderAdapterFactorySpec.getImage(this.getRootAdapterFactory(), match.getOrigin());
        }
        if (ret == null) {
            ret = super.getImage(object);
        }
        return ret;
    }

    @Override
    public String getText(Object object) {
        Match match = (Match)object;
        String ret = CompareItemProviderAdapterFactorySpec.getText(this.getRootAdapterFactory(), match.getLeft());
        if (ret == null) {
            ret = CompareItemProviderAdapterFactorySpec.getText(this.getRootAdapterFactory(), match.getRight());
        }
        if (ret == null) {
            ret = CompareItemProviderAdapterFactorySpec.getText(this.getRootAdapterFactory(), match.getOrigin());
        }
        if (ret == null) {
            ret = super.getText(object);
        }
        return ret;
    }

    public Collection<?> getChildren(Object object) {
        Match match = (Match)object;
        Iterable<Object> filteredChildren = this.getChildrenIterable(match);
        return ImmutableList.copyOf(filteredChildren);
    }

    Iterable<Object> getChildrenIterable(Match match) {
        ImmutableSet<EObject> containementDifferenceValues = this.containmentReferencesValues(match);
        Predicate childrenFilter = Predicates.not((Predicate)Predicates.or((Predicate[])new Predicate[]{MatchItemProviderSpec.matchOfContainmentDiff(containementDifferenceValues), this.matchWithNoChildren(), PSEUDO_CONFLICT_DIFF, REFINED_OR_REQUIRED_BY_REFINED_DIFF, PSEUDO_DELETE_CONFLICT}));
        Iterable filteredChildren = Iterables.filter((Iterable)Iterables.filter((Iterable)super.getChildren((Object)match), Object.class), (Predicate)childrenFilter);
        return filteredChildren;
    }

    private ImmutableSet<EObject> containmentReferencesValues(Match match) {
        EList differences = match.getDifferences();
        Iterable containmentReferenceChanges = Iterables.filter((Iterable)Iterables.filter((Iterable)differences, ReferenceChange.class), CONTAINMENT_REFERENCE_CHANGE);
        ImmutableSet containementDifferenceValues = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)containmentReferenceChanges, VALUE));
        return containementDifferenceValues;
    }

    private static Predicate<? super Object> matchOfContainmentDiff(final ImmutableSet<EObject> containementDifferenceValues) {
        return new Predicate<Object>(){

            public boolean apply(Object input) {
                Match match;
                boolean ret = false;
                if (input instanceof Match && (containementDifferenceValues.contains((Object)(match = (Match)input).getLeft()) || containementDifferenceValues.contains((Object)match.getRight()) || containementDifferenceValues.contains((Object)match.getOrigin()))) {
                    ret = true;
                }
                return ret;
            }
        };
    }

    private final Predicate<? super Object> matchWithNoChildren() {
        return new Predicate<Object>(){

            public boolean apply(Object input) {
                boolean ret = false;
                if (input instanceof Match) {
                    Match match = (Match)input;
                    ret = MatchItemProviderSpec.this.getChildren(match).isEmpty();
                }
                return ret;
            }
        };
    }

    public boolean hasChildren(Object object) {
        Match match = (Match)object;
        return !Iterables.isEmpty(this.getChildrenIterable(match));
    }
}

