/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.logical.extension;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.logical.extension.IModelResolver;
import org.eclipse.emf.compare.ide.logical.extension.ModelResourceVisitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopedModelResolver
implements IModelResolver {
    private Set<Resource> walkedResources = new HashSet<Resource>();

    @Override
    public void resolve(IFile iFile, Resource eResource) {
        ResourceSetImpl temporaryResourceSet = new ResourceSetImpl();
        IContainer container = this.getScope(iFile);
        try {
            container.accept((IResourceVisitor)new ModelResourceVisitor((ResourceSet)temporaryResourceSet));
        }
        catch (CoreException coreException) {}
        URI resourceURI = eResource.getURI();
        Resource baseResource = temporaryResourceSet.getResource(resourceURI, false);
        if (baseResource != null) {
            GreedyCrossReferencer crossReferencer = new GreedyCrossReferencer((ResourceSet)temporaryResourceSet);
            Set<Resource> crossReferencingResources = this.findCrossReferencingResources((EcoreUtil.CrossReferencer)crossReferencer, baseResource);
            ResourceSet baseResourceSet = eResource.getResourceSet();
            for (Resource crossReferencing : crossReferencingResources) {
                baseResourceSet.getResource(crossReferencing.getURI(), true);
            }
            for (Resource temporaryResource : temporaryResourceSet.getResources()) {
                temporaryResource.unload();
            }
            temporaryResourceSet.getResources().clear();
        }
        EcoreUtil.resolveAll((ResourceSet)eResource.getResourceSet());
    }

    protected IContainer getScope(IFile iFile) {
        return iFile.getParent();
    }

    protected Set<Resource> findCrossReferencingResources(EcoreUtil.CrossReferencer crossReferencer, Resource baseResource) {
        HashSet<Resource> crossReferencingResources = new HashSet<Resource>();
        if (this.walkedResources.contains(baseResource)) {
            return crossReferencingResources;
        }
        this.walkedResources.add(baseResource);
        for (EObject root : baseResource.getContents()) {
            crossReferencingResources.addAll(this.findCrossReferencingResources(crossReferencer, root));
            TreeIterator rootContent = root.eAllContents();
            while (rootContent.hasNext()) {
                crossReferencingResources.addAll(this.findCrossReferencingResources(crossReferencer, (EObject)rootContent.next()));
            }
        }
        for (Resource crossReferencing : new HashSet<Resource>(crossReferencingResources)) {
            crossReferencingResources.addAll(this.findCrossReferencingResources(crossReferencer, crossReferencing));
        }
        return crossReferencingResources;
    }

    protected Set<Resource> findCrossReferencingResources(EcoreUtil.CrossReferencer crossReferencer, EObject object) {
        HashSet<Resource> crossReferencingResources = new HashSet<Resource>();
        Resource baseResource = object.eResource();
        Collection crossReferences = (Collection)crossReferencer.get((Object)object);
        if (crossReferences != null) {
            Iterator crossReferenceIterator = crossReferences.iterator();
            while (crossReferenceIterator.hasNext()) {
                EObject nextObject = ((EStructuralFeature.Setting)crossReferenceIterator.next()).getEObject();
                Resource nextResource = nextObject.eResource();
                if (baseResource == nextResource) continue;
                crossReferencingResources.add(nextResource);
            }
        }
        return crossReferencingResources;
    }

    private final class GreedyCrossReferencer
    extends EcoreUtil.CrossReferencer {
        private static final long serialVersionUID = 1L;

        public GreedyCrossReferencer(ResourceSet resourceSet) {
            super(resourceSet);
            this.crossReference();
        }
    }
}

