/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.logical.sync;

import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.compare.ide.logical.EMFModelProvider;
import org.eclipse.emf.compare.ide.logical.EMFResourceMapping;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.team.core.mapping.ISynchronizationContext;

public final class EMFSynchronizationModel {
    private String modelProviderId;
    private ISynchronizationContext context;
    private ResourceSet leftResourceSet;
    private ResourceSet rightResourceSet;
    private ResourceSet originResourceSet;

    private EMFSynchronizationModel(ISynchronizationContext context, String modelProviderId) {
        this.modelProviderId = modelProviderId;
        this.context = context;
    }

    public static EMFSynchronizationModel createModel(ISynchronizationContext context, String modelProviderId, IProgressMonitor monitor) throws CoreException {
        EMFSynchronizationModel model = new EMFSynchronizationModel(context, modelProviderId);
        model.initialize(monitor);
        context.getCache().put("org.eclipse.emf.compare.model.provider.sync.cache", (Object)model);
        return model;
    }

    public static EMFSynchronizationModel getModel(ISynchronizationContext context) {
        return (EMFSynchronizationModel)context.getCache().get("org.eclipse.emf.compare.model.provider.sync.cache");
    }

    public void dispose() {
        this.leftResourceSet = null;
        this.rightResourceSet = null;
        this.originResourceSet = null;
    }

    public ResourceSet getLeftResourceSet() {
        return this.leftResourceSet;
    }

    public ResourceSet getRightResourceSet() {
        return this.rightResourceSet;
    }

    public ResourceSet getOriginResourceSet() {
        return this.originResourceSet;
    }

    private void initialize(IProgressMonitor monitor) throws CoreException {
        this.dispose();
        ResourceMapping[] mappings = EMFModelProvider.getAdditionalMappings(this.context);
        if (mappings == null) {
            mappings = this.context.getScope().getMappings();
        }
        ResourceMapping[] resourceMappingArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            if (this.modelProviderId.equals(mapping.getModelProviderId()) && mapping instanceof EMFResourceMapping) {
                EMFResourceMapping emfMapping = (EMFResourceMapping)mapping;
                ResourceSet left = emfMapping.getLocalResourceSet();
                ResourceSet right = emfMapping.getRemoteResourceSet();
                ResourceSet origin = emfMapping.getOriginResourceSet();
                if (left != null && right != null && origin != null && (this.leftResourceSet == null || this.leftResourceSet.getResources().size() < left.getResources().size())) {
                    this.leftResourceSet = left;
                    this.rightResourceSet = right;
                    this.originResourceSet = origin;
                }
            }
            ++n2;
        }
        if (this.leftResourceSet == null) {
            EMFResourceMapping emfMapping = null;
            int i = 0;
            while (i < mappings.length && emfMapping == null) {
                ResourceMapping mapping = mappings[i];
                if (this.modelProviderId.equals(mapping.getModelProviderId()) && mapping instanceof EMFResourceMapping) {
                    emfMapping = (EMFResourceMapping)mapping;
                }
                ++i;
            }
            if (emfMapping != null) {
                emfMapping.forceResolving(this.context.getScope().getContext(), monitor);
                this.leftResourceSet = emfMapping.getLocalResourceSet();
                this.rightResourceSet = emfMapping.getRemoteResourceSet();
                this.originResourceSet = emfMapping.getOriginResourceSet();
            }
        }
    }
}

