/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.mergeviewer.accessor;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.MergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.accessor.IStructuralFeatureAccessor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicStructuralFeatureAccessorImpl
implements IStructuralFeatureAccessor {
    private final Diff fDiff;
    private final MergeViewer.MergeViewerSide fSide;
    private final Match fOwnerMatch;
    private final EStructuralFeature fStructuralFeature;
    private final ImmutableList<Diff> fDifferences;

    public BasicStructuralFeatureAccessorImpl(Diff diff, MergeViewer.MergeViewerSide side) {
        this.fDiff = diff;
        this.fSide = side;
        this.fOwnerMatch = diff.getMatch();
        this.fStructuralFeature = BasicStructuralFeatureAccessorImpl.getDiffFeature(diff);
        EList siblingDifferences = this.fOwnerMatch.getDifferences();
        Predicate<Diff> diffWithThisFeature = BasicStructuralFeatureAccessorImpl.diffWithThisFeature(this.fStructuralFeature);
        this.fDifferences = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)siblingDifferences, diffWithThisFeature));
    }

    @Override
    public Comparison getComparison() {
        return this.fOwnerMatch.getComparison();
    }

    @Override
    public IMergeViewerItem getInitialItem() {
        IMergeViewerItem ret = null;
        ImmutableList<? extends IMergeViewerItem> items = this.getItems();
        for (IMergeViewerItem item : items) {
            Diff diff = item.getDiff();
            if (diff != this.fDiff) continue;
            ret = item;
        }
        return ret;
    }

    @Override
    public EObject getEObject(MergeViewer.MergeViewerSide side) {
        EObject eObject;
        switch (side) {
            case ANCESTOR: {
                eObject = this.fOwnerMatch.getOrigin();
                break;
            }
            case LEFT: {
                eObject = this.fOwnerMatch.getLeft();
                break;
            }
            case RIGHT: {
                eObject = this.fOwnerMatch.getRight();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return eObject;
    }

    @Override
    public EStructuralFeature getStructuralFeature() {
        return this.fStructuralFeature;
    }

    protected final MergeViewer.MergeViewerSide getSide() {
        return this.fSide;
    }

    protected final ImmutableList<Diff> getDifferences() {
        return this.fDifferences;
    }

    private static Predicate<Diff> diffWithThisFeature(final EStructuralFeature thisFeature) {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                EStructuralFeature feature = BasicStructuralFeatureAccessorImpl.getDiffFeature(input);
                return feature == thisFeature;
            }
        };
    }

    private static EStructuralFeature getDiffFeature(Diff siblingDiff) {
        Object feature = siblingDiff instanceof ReferenceChange ? ((ReferenceChange)siblingDiff).getReference() : (siblingDiff instanceof AttributeChange ? ((AttributeChange)siblingDiff).getAttribute() : null);
        return feature;
    }
}

