/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompareConfiguration;
import org.eclipse.emf.compare.conflict.DefaultConflictDetector;
import org.eclipse.emf.compare.diff.DefaultDiffEngine;
import org.eclipse.emf.compare.diff.DiffBuilder;
import org.eclipse.emf.compare.equi.DefaultEquiEngine;
import org.eclipse.emf.compare.extension.EMFCompareExtensionRegistry;
import org.eclipse.emf.compare.extension.IPostProcessor;
import org.eclipse.emf.compare.extension.PostProcessorDescriptor;
import org.eclipse.emf.compare.match.DefaultMatchEngine;
import org.eclipse.emf.compare.match.eobject.EditionDistance;
import org.eclipse.emf.compare.match.eobject.IEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.IdentifierEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.ProximityEObjectMatcher;
import org.eclipse.emf.compare.req.DefaultReqEngine;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.EqualityHelper;
import org.eclipse.emf.compare.utils.UseIdentifiers;

public final class EMFCompare {
    private IEObjectMatcher eObjectMatcher;
    private EqualityHelper equalityHelper;
    private Monitor progressMonitor;
    private final IComparisonScope scope;
    private UseIdentifiers useIDs = UseIdentifiers.WHEN_AVAILABLE;

    private EMFCompare(IComparisonScope scope) {
        Preconditions.checkNotNull((Object)scope);
        this.scope = scope;
    }

    public static EMFCompareConfiguration createDefaultConfiguration() {
        BasicMonitor monitor = new BasicMonitor();
        EqualityHelper equalityHelper = new EqualityHelper();
        return new EMFCompareConfiguration((Monitor)monitor, equalityHelper);
    }

    public static IComparisonScope createDefaultScope(Notifier left, Notifier right) {
        return new DefaultComparisonScope(left, right, null);
    }

    public static IComparisonScope createDefaultScope(Notifier left, Notifier right, Notifier origin) {
        return new DefaultComparisonScope(left, right, origin);
    }

    public static EMFCompare newComparator(IComparisonScope scope) {
        return new EMFCompare(scope);
    }

    private static Comparison compare(IComparisonScope scope, EMFCompareConfiguration configuration, IEObjectMatcher matcher) {
        DefaultMatchEngine matchEngine = new DefaultMatchEngine(matcher);
        Comparison comparison = matchEngine.match(scope, configuration);
        IPostProcessor postProcessor = EMFCompare.getPostProcessor(scope);
        if (postProcessor != null) {
            postProcessor.postMatch(comparison);
        }
        DiffBuilder diffBuilder = new DiffBuilder();
        DefaultDiffEngine diffEngine = new DefaultDiffEngine(diffBuilder);
        diffEngine.diff(comparison);
        if (postProcessor != null) {
            postProcessor.postDiff(comparison);
        }
        DefaultReqEngine reqEngine = new DefaultReqEngine();
        reqEngine.computeRequirements(comparison);
        if (postProcessor != null) {
            postProcessor.postRequirements(comparison);
        }
        DefaultEquiEngine equiEngine = new DefaultEquiEngine();
        equiEngine.computeEquivalences(comparison);
        if (postProcessor != null) {
            postProcessor.postEquivalences(comparison);
        }
        if (comparison.isThreeWay()) {
            DefaultConflictDetector conflictDetector = new DefaultConflictDetector();
            conflictDetector.detect(comparison);
            if (postProcessor != null) {
                postProcessor.postConflicts(comparison);
            }
        }
        return comparison;
    }

    private static IPostProcessor getPostProcessor(IComparisonScope scope) {
        IPostProcessor postProcessor = null;
        Iterator<PostProcessorDescriptor> postProcessorIterator = EMFCompareExtensionRegistry.getRegisteredPostProcessors().iterator();
        while (postProcessorIterator.hasNext() && postProcessor == null) {
            PostProcessorDescriptor descriptor = postProcessorIterator.next();
            if (descriptor.getNsURI() != null && descriptor.getNsURI().trim().length() != 0) {
                Iterator<String> nsUris = scope.getNsURIs().iterator();
                while (nsUris.hasNext() && postProcessor == null) {
                    if (!nsUris.next().matches(descriptor.getNsURI())) continue;
                    postProcessor = descriptor.getPostProcessor();
                }
            }
            if (descriptor.getResourceURI() == null || descriptor.getResourceURI().trim().length() == 0) continue;
            Iterator<String> resourceUris = scope.getResourceURIs().iterator();
            while (resourceUris.hasNext() && postProcessor == null) {
                if (!resourceUris.next().matches(descriptor.getResourceURI())) continue;
                postProcessor = descriptor.getPostProcessor();
            }
        }
        return postProcessor;
    }

    public Comparison compare() {
        Object monitor = this.progressMonitor != null ? this.progressMonitor : new BasicMonitor();
        EqualityHelper helper = this.equalityHelper != null ? this.equalityHelper : new EqualityHelper();
        EMFCompareConfiguration configuration = new EMFCompareConfiguration((Monitor)monitor, helper);
        IEObjectMatcher matcher = this.createMatcher(helper);
        return EMFCompare.compare(this.scope, configuration, matcher);
    }

    public EMFCompare matchByID(UseIdentifiers matchByID) {
        if (matchByID != null) {
            this.useIDs = matchByID;
        }
        return this;
    }

    public EMFCompare setEObjectMatcher(IEObjectMatcher matcher) {
        if (matcher != null) {
            this.eObjectMatcher = matcher;
        }
        return this;
    }

    public EMFCompare setEqualityHelper(EqualityHelper helper) {
        if (helper != null) {
            this.equalityHelper = helper;
        }
        return this;
    }

    public EMFCompare setMonitor(Monitor monitor) {
        if (monitor != null) {
            this.progressMonitor = monitor;
        }
        return this;
    }

    private IEObjectMatcher createMatcher(EqualityHelper helper) {
        IEObjectMatcher matcher;
        if (this.eObjectMatcher != null) {
            return this.eObjectMatcher;
        }
        switch (this.useIDs) {
            case NEVER: {
                matcher = ProximityEObjectMatcher.builder(EditionDistance.builder(helper).build()).build();
                break;
            }
            case ONLY: {
                matcher = new IdentifierEObjectMatcher();
                break;
            }
            default: {
                ProximityEObjectMatcher contentMatcher = ProximityEObjectMatcher.builder(EditionDistance.builder(helper).build()).build();
                matcher = new IdentifierEObjectMatcher(contentMatcher);
            }
        }
        return matcher;
    }
}

