/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.eobject;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;

public class URIDistance {
    public int proximity(String str1, String str2) {
        Splitter splitter = Splitter.on((char)'/').trimResults().omitEmptyStrings();
        ArrayList fragments1 = Lists.newArrayList((Iterable)splitter.split((CharSequence)str1));
        ArrayList fragments2 = Lists.newArrayList((Iterable)splitter.split((CharSequence)str2));
        if (fragments1.size() == 0 && fragments2.size() == 0) {
            return 0;
        }
        int frag2Size = fragments2.size();
        int commonPart = 0;
        int i = 0;
        while (i < fragments1.size()) {
            String f1 = (String)fragments1.get(i);
            if (i >= frag2Size || !f1.equals(fragments2.get(i))) break;
            ++commonPart;
            ++i;
        }
        int totalFrag = Math.max(fragments2.size(), fragments1.size());
        double similarity = (double)commonPart * 10.0 / (double)totalFrag;
        return 10 - (int)similarity;
    }
}

