/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.utils;

import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.lang.reflect.Array;
import java.util.concurrent.ExecutionException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;

public class EqualityHelper {
    private Cache<EObject, URI> uriCache = CacheBuilder.newBuilder().build(CacheLoader.from((Function)new URICacheFunction()));

    public boolean matchingValues(Comparison comparison, Object object1, Object object2) {
        boolean equal;
        Object converted2;
        Object converted1 = this.internalFindActualObject(object1);
        if (converted1 == (converted2 = this.internalFindActualObject(object2))) {
            equal = true;
        } else if (converted1 instanceof EEnumLiteral && converted2 instanceof EEnumLiteral) {
            EEnumLiteral literal1 = (EEnumLiteral)converted1;
            EEnumLiteral literal2 = (EEnumLiteral)converted2;
            String value1 = String.valueOf(literal1.getLiteral()) + literal1.getValue();
            String value2 = String.valueOf(literal2.getLiteral()) + literal2.getValue();
            equal = value1.equals(value2);
        } else {
            equal = converted1 instanceof EObject && converted2 instanceof EObject ? this.matchingEObjects(comparison, (EObject)converted1, (EObject)converted2) : (converted1 != null && converted1.getClass().isArray() && converted2 != null && converted2.getClass().isArray() ? this.matchingArrays(comparison, converted1, converted2) : (this.isNullOrEmptyString(converted1) && this.isNullOrEmptyString(converted2) ? true : converted1 != null && converted1.equals(converted2)));
        }
        return equal;
    }

    private boolean isNullOrEmptyString(Object object) {
        return object == null || object instanceof String && ((String)object).length() == 0;
    }

    private boolean matchingArrays(Comparison comparison, Object object1, Object object2) {
        boolean equal = true;
        int length1 = Array.getLength(object1);
        if (length1 != Array.getLength(object2)) {
            equal = true;
        } else {
            int i = 0;
            while (i < length1 && equal) {
                Object element1 = Array.get(object1, i);
                Object element2 = Array.get(object2, i);
                equal = this.matchingValues(comparison, element1, element2);
                ++i;
            }
        }
        return equal;
    }

    private boolean matchingEObjects(Comparison comparison, EObject object1, EObject object2) {
        boolean equal;
        Match match = comparison.getMatch(object1);
        if (match != null) {
            equal = match.getLeft() == object2 || match.getRight() == object2 || match.getOrigin() == object2;
        } else {
            boolean temp = false;
            try {
                URI uri1 = (URI)this.uriCache.get((Object)object1);
                URI uri2 = (URI)this.uriCache.get((Object)object2);
                temp = uri1.hasFragment() && uri2.hasFragment() ? uri1.fragment().equals(uri2.fragment()) : uri1.equals((Object)uri2);
            }
            catch (ExecutionException executionException) {}
            equal = temp;
        }
        return equal;
    }

    public boolean matchingAttributeValues(Object object1, Object object2) {
        boolean equal;
        Object converted2;
        Object converted1 = this.internalFindActualObject(object1);
        if (converted1 == (converted2 = this.internalFindActualObject(object2))) {
            equal = true;
        } else if (converted1 instanceof EEnumLiteral && converted2 instanceof EEnumLiteral) {
            EEnumLiteral literal1 = (EEnumLiteral)converted1;
            EEnumLiteral literal2 = (EEnumLiteral)converted2;
            String value1 = String.valueOf(literal1.getLiteral()) + literal1.getValue();
            String value2 = String.valueOf(literal2.getLiteral()) + literal2.getValue();
            equal = value1.equals(value2);
        } else {
            equal = converted1 != null && converted1.getClass().isArray() && converted2 != null && converted2.getClass().isArray() ? this.matchingArrays(converted1, converted2) : (this.isNullOrEmptyString(converted1) && this.isNullOrEmptyString(converted2) ? true : converted1 != null && converted1.equals(converted2));
        }
        return equal;
    }

    private boolean matchingArrays(Object object1, Object object2) {
        boolean equal = true;
        int length1 = Array.getLength(object1);
        if (length1 != Array.getLength(object2)) {
            equal = true;
        } else {
            int i = 0;
            while (i < length1 && equal) {
                Object element1 = Array.get(object1, i);
                Object element2 = Array.get(object2, i);
                equal = this.matchingAttributeValues(element1, element2);
                ++i;
            }
        }
        return equal;
    }

    public URI getURI(EObject object) {
        try {
            return (URI)this.uriCache.get((Object)object);
        }
        catch (ExecutionException executionException) {
            return null;
        }
    }

    private Object internalFindActualObject(Object data) {
        if (data instanceof FeatureMap.Entry) {
            return this.internalFindActualObject(((FeatureMap.Entry)data).getValue());
        }
        return data;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class URICacheFunction
    implements Function<EObject, URI> {
        private URICacheFunction() {
        }

        public URI apply(EObject input) {
            if (input == null) {
                return null;
            }
            return EcoreUtil.getURI((EObject)input);
        }
    }
}

