/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.provider.spec;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.uml2.UMLDiff;
import org.eclipse.emf.compare.uml2.internal.utils.ForwardingItemProvider;
import org.eclipse.emf.compare.uml2.internal.utils.Strings;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForwardingUMLDiffItemProvider
extends ForwardingItemProvider {
    public ForwardingUMLDiffItemProvider(ItemProviderAdapter delegate) {
        super(delegate);
    }

    @Override
    public Collection<?> getChildren(Object object) {
        UMLDiff umlDiff = (UMLDiff)object;
        Object ret = umlDiff.getKind() == DifferenceKind.CHANGE ? umlDiff.getRefinedBy() : super.getChildren(object);
        return ret;
    }

    @Override
    public boolean hasChildren(Object object) {
        return !this.getChildren(object).isEmpty();
    }

    @Override
    public String getText(Object object) {
        UMLDiff umlDiff = (UMLDiff)object;
        String valueText = this.getValueText(umlDiff);
        String referenceText = this.getReferenceText(umlDiff);
        String remotely = "";
        if (umlDiff.getSource() == DifferenceSource.RIGHT) {
            remotely = "remotely ";
        }
        String ret = "";
        switch (umlDiff.getKind()) {
            case ADD: {
                ret = String.valueOf(valueText) + " has been " + remotely + "added to " + referenceText;
                break;
            }
            case DELETE: {
                ret = String.valueOf(valueText) + " has been " + remotely + "deleted from " + referenceText;
                break;
            }
            case CHANGE: {
                ret = String.valueOf(valueText) + " has been " + remotely + "changed";
                break;
            }
            case MOVE: {
                ret = String.valueOf(valueText) + " has been " + remotely + "moved in " + referenceText;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + umlDiff.getKind());
            }
        }
        return ret;
    }

    @Override
    public Object getImage(Object object) {
        UMLDiff umlDiff = (UMLDiff)object;
        Object image = ForwardingUMLDiffItemProvider.getImage(this.getRootAdapterFactory(), umlDiff.getDiscriminant());
        return image;
    }

    private String getValueText(UMLDiff umlDiff) {
        String value = ForwardingUMLDiffItemProvider.getText(this.getRootAdapterFactory(), umlDiff.getDiscriminant());
        value = value == null ? "<null>" : Strings.elide(value, 25, "...");
        return value;
    }

    private String getReferenceText(UMLDiff umlDiff) {
        String ret = "";
        switch (umlDiff.getKind()) {
            case ADD: 
            case DELETE: 
            case MOVE: {
                EObject discriminant = umlDiff.getDiscriminant();
                EList refinedBy = umlDiff.getRefinedBy();
                for (Diff diff : refinedBy) {
                    if (diff instanceof ReferenceChange) {
                        if (((ReferenceChange)diff).getValue() != discriminant) continue;
                        ret = ((ReferenceChange)diff).getReference().getName();
                        continue;
                    }
                    boolean cfr_ignored_0 = diff instanceof AttributeChange;
                }
                break;
            }
            case CHANGE: {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + umlDiff.getKind());
            }
        }
        return ret;
    }

    private static String getText(AdapterFactory adapterFactory, Object object) {
        Object adapter;
        Preconditions.checkNotNull((Object)adapterFactory);
        if (object != null && (adapter = adapterFactory.adapt(object, IItemLabelProvider.class)) instanceof IItemLabelProvider) {
            return ((IItemLabelProvider)adapter).getText(object);
        }
        return null;
    }

    private static Object getImage(AdapterFactory adapterFactory, Object object) {
        Object adapter;
        Preconditions.checkNotNull((Object)adapterFactory);
        if (object != null && (adapter = adapterFactory.adapt(object, IItemLabelProvider.class)) instanceof IItemLabelProvider) {
            return ((IItemLabelProvider)adapter).getImage(object);
        }
        return null;
    }
}

