/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.ide.ui.internal.provider;

import org.eclipse.compare.ITypedElement;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.DiffNode;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.MergeViewer;
import org.eclipse.emf.compare.uml2.UMLDiff;
import org.eclipse.emf.compare.uml2.ide.ui.internal.accessor.UMLIDEManyStructuralFeatureAccessorImpl;
import org.eclipse.emf.compare.uml2.ide.ui.internal.accessor.UMLIDESingleStructuralFeatureAccessorImpl;
import org.eclipse.emf.ecore.EReference;

public class UMLDiffNode
extends DiffNode {
    public UMLDiffNode(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public UMLDiff getTarget() {
        return (UMLDiff)super.getTarget();
    }

    public ITypedElement getLeft() {
        return this.getAccessor(MergeViewer.MergeViewerSide.LEFT);
    }

    public ITypedElement getRight() {
        return this.getAccessor(MergeViewer.MergeViewerSide.RIGHT);
    }

    public ITypedElement getAncestor() {
        return this.getAccessor(MergeViewer.MergeViewerSide.ANCESTOR);
    }

    private ITypedElement getAccessor(MergeViewer.MergeViewerSide side) {
        Object ret = null;
        UMLDiff diff = this.getTarget();
        switch (diff.getKind()) {
            case ADD: 
            case DELETE: 
            case MOVE: {
                EReference eReference = diff.getEReference();
                if (eReference.isMany()) {
                    ret = new UMLIDEManyStructuralFeatureAccessorImpl((Diff)diff, side);
                    break;
                }
                ret = new UMLIDESingleStructuralFeatureAccessorImpl((Diff)diff, side);
                break;
            }
            case CHANGE: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return ret;
    }
}

